/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.sep;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.codecs.MultiLevelSkipListReader;
import org.apache.lucene.codecs.sep.IntIndexInput;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;

class SepSkipListReader
extends MultiLevelSkipListReader {
    private boolean currentFieldStoresPayloads;
    private IntIndexInput.Index[] freqIndex;
    private IntIndexInput.Index[] docIndex;
    private IntIndexInput.Index[] posIndex;
    private long[] payloadPointer;
    private int[] payloadLength;
    private final IntIndexInput.Index lastFreqIndex;
    private final IntIndexInput.Index lastDocIndex;
    final IntIndexInput.Index lastPosIndex;
    private long lastPayloadPointer;
    private int lastPayloadLength;
    FieldInfo.IndexOptions indexOptions;

    SepSkipListReader(IndexInput skipStream, IntIndexInput freqIn, IntIndexInput docIn, IntIndexInput posIn, int maxSkipLevels, int skipInterval) throws IOException {
        super(skipStream, maxSkipLevels, skipInterval);
        if (freqIn != null) {
            this.freqIndex = new IntIndexInput.Index[maxSkipLevels];
        }
        this.docIndex = new IntIndexInput.Index[maxSkipLevels];
        if (posIn != null) {
            this.posIndex = new IntIndexInput.Index[this.maxNumberOfSkipLevels];
        }
        for (int i = 0; i < maxSkipLevels; ++i) {
            if (freqIn != null) {
                this.freqIndex[i] = freqIn.index();
            }
            this.docIndex[i] = docIn.index();
            if (posIn == null) continue;
            this.posIndex[i] = posIn.index();
        }
        this.payloadPointer = new long[maxSkipLevels];
        this.payloadLength = new int[maxSkipLevels];
        this.lastFreqIndex = freqIn != null ? freqIn.index() : null;
        this.lastDocIndex = docIn.index();
        this.lastPosIndex = posIn != null ? posIn.index() : null;
    }

    void setIndexOptions(FieldInfo.IndexOptions v) {
        this.indexOptions = v;
    }

    void init(long skipPointer, IntIndexInput.Index docBaseIndex, IntIndexInput.Index freqBaseIndex, IntIndexInput.Index posBaseIndex, long payloadBasePointer, int df, boolean storesPayloads) {
        super.init(skipPointer, df);
        this.currentFieldStoresPayloads = storesPayloads;
        this.lastPayloadPointer = payloadBasePointer;
        for (int i = 0; i < this.maxNumberOfSkipLevels; ++i) {
            this.docIndex[i].copyFrom(docBaseIndex);
            if (this.freqIndex != null) {
                this.freqIndex[i].copyFrom(freqBaseIndex);
            }
            if (posBaseIndex == null) continue;
            this.posIndex[i].copyFrom(posBaseIndex);
        }
        Arrays.fill(this.payloadPointer, payloadBasePointer);
        Arrays.fill(this.payloadLength, 0);
    }

    long getPayloadPointer() {
        return this.lastPayloadPointer;
    }

    int getPayloadLength() {
        return this.lastPayloadLength;
    }

    protected void seekChild(int level) throws IOException {
        super.seekChild(level);
        this.payloadPointer[level] = this.lastPayloadPointer;
        this.payloadLength[level] = this.lastPayloadLength;
    }

    protected void setLastSkipData(int level) {
        super.setLastSkipData(level);
        this.lastPayloadPointer = this.payloadPointer[level];
        this.lastPayloadLength = this.payloadLength[level];
        if (this.freqIndex != null) {
            this.lastFreqIndex.copyFrom(this.freqIndex[level]);
        }
        this.lastDocIndex.copyFrom(this.docIndex[level]);
        if (this.lastPosIndex != null) {
            this.lastPosIndex.copyFrom(this.posIndex[level]);
        }
        if (level > 0) {
            if (this.freqIndex != null) {
                this.freqIndex[level - 1].copyFrom(this.freqIndex[level]);
            }
            this.docIndex[level - 1].copyFrom(this.docIndex[level]);
            if (this.posIndex != null) {
                this.posIndex[level - 1].copyFrom(this.posIndex[level]);
            }
        }
    }

    IntIndexInput.Index getFreqIndex() {
        return this.lastFreqIndex;
    }

    IntIndexInput.Index getPosIndex() {
        return this.lastPosIndex;
    }

    IntIndexInput.Index getDocIndex() {
        return this.lastDocIndex;
    }

    protected int readSkipData(int level, IndexInput skipStream) throws IOException {
        int delta;
        assert (this.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS || !this.currentFieldStoresPayloads);
        if (this.currentFieldStoresPayloads) {
            delta = skipStream.readVInt();
            if ((delta & 1) != 0) {
                this.payloadLength[level] = skipStream.readVInt();
            }
            delta >>>= 1;
        } else {
            delta = skipStream.readVInt();
        }
        if (this.indexOptions != FieldInfo.IndexOptions.DOCS_ONLY) {
            this.freqIndex[level].read((DataInput)skipStream, false);
        }
        this.docIndex[level].read((DataInput)skipStream, false);
        if (this.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
            this.posIndex[level].read((DataInput)skipStream, false);
            if (this.currentFieldStoresPayloads) {
                int n = level;
                this.payloadPointer[n] = this.payloadPointer[n] + (long)skipStream.readVInt();
            }
        }
        return delta;
    }
}

