/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.healthcheck;

import java.util.LinkedList;
import java.util.Map;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.PropertyKey;
import org.apache.helix.ZNRecord;
import org.apache.helix.healthcheck.HealthReportProvider;
import org.apache.helix.healthcheck.ParticipantHealthReportCollector;
import org.apache.helix.model.HealthStat;
import org.apache.log4j.Logger;

public class ParticipantHealthReportCollectorImpl
implements ParticipantHealthReportCollector {
    private final LinkedList<HealthReportProvider> _healthReportProviderList = new LinkedList();
    private static final Logger _logger = Logger.getLogger(ParticipantHealthReportCollectorImpl.class);
    private final HelixManager _helixManager;
    String _instanceName;

    public ParticipantHealthReportCollectorImpl(HelixManager helixManager, String instanceName) {
        this._helixManager = helixManager;
        this._instanceName = instanceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHealthReportProvider(HealthReportProvider provider) {
        try {
            LinkedList<HealthReportProvider> linkedList = this._healthReportProviderList;
            synchronized (linkedList) {
                if (!this._healthReportProviderList.contains(provider)) {
                    this._healthReportProviderList.add(provider);
                } else {
                    _logger.warn((Object)"Skipping a duplicated HealthCheckInfoProvider");
                }
            }
        }
        catch (Exception e) {
            _logger.error((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHealthReportProvider(HealthReportProvider provider) {
        LinkedList<HealthReportProvider> linkedList = this._healthReportProviderList;
        synchronized (linkedList) {
            if (this._healthReportProviderList.contains(provider)) {
                this._healthReportProviderList.remove(provider);
            } else {
                _logger.warn((Object)"Skip removing a non-exist HealthCheckInfoProvider");
            }
        }
    }

    @Override
    public void reportHealthReportMessage(ZNRecord healthCheckInfoUpdate) {
        HelixDataAccessor accessor = this._helixManager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        accessor.setProperty(keyBuilder.healthReport(this._instanceName, healthCheckInfoUpdate.getId()), new HealthStat(healthCheckInfoUpdate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void transmitHealthReports() {
        LinkedList<HealthReportProvider> linkedList = this._healthReportProviderList;
        synchronized (linkedList) {
            for (HealthReportProvider provider : this._healthReportProviderList) {
                try {
                    Map<String, String> report = provider.getRecentHealthReport();
                    Map<String, Map<String, String>> partitionReport = provider.getRecentPartitionHealthReport();
                    ZNRecord record = new ZNRecord(provider.getReportName());
                    if (report != null) {
                        record.setSimpleFields(report);
                    }
                    if (partitionReport != null) {
                        record.setMapFields(partitionReport);
                    }
                    record.setSimpleField("TimeStamp", "" + System.currentTimeMillis());
                    HelixDataAccessor accessor = this._helixManager.getHelixDataAccessor();
                    PropertyKey.Builder keyBuilder = accessor.keyBuilder();
                    accessor.setProperty(keyBuilder.healthReport(this._instanceName, record.getId()), new HealthStat(record));
                    provider.resetStats();
                }
                catch (Exception e) {
                    _logger.error((Object)"fail to transmit health report", (Throwable)e);
                }
            }
        }
    }
}

