/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.helix.HelixException;
import org.apache.helix.ZNRecord;
import org.apache.helix.util.GZipCompressionUtil;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;

public class ZNRecordSerializer
implements ZkSerializer {
    private static Logger logger = Logger.getLogger(ZNRecordSerializer.class);

    private static int getListFieldBound(ZNRecord record) {
        int max = Integer.MAX_VALUE;
        if (record.getSimpleFields().containsKey("listField.bound")) {
            String maxStr = record.getSimpleField("listField.bound");
            try {
                max = Integer.parseInt(maxStr);
            }
            catch (Exception e) {
                logger.error((Object)("IllegalNumberFormat for list field bound: " + maxStr));
            }
        }
        return max;
    }

    public byte[] serialize(Object data) {
        if (!(data instanceof ZNRecord)) {
            logger.error((Object)("Input object must be of type ZNRecord but it is " + data + ". Will not write to zk"));
            throw new HelixException("Input object is not of type ZNRecord (was " + data + ")");
        }
        ZNRecord record = (ZNRecord)data;
        int max = ZNRecordSerializer.getListFieldBound(record);
        if (max < Integer.MAX_VALUE) {
            Map<String, List<String>> listMap = record.getListFields();
            for (String key : listMap.keySet()) {
                List<String> list = listMap.get(key);
                if (list.size() <= max) continue;
                listMap.put(key, list.subList(0, max));
            }
        }
        ObjectMapper mapper = new ObjectMapper();
        SerializationConfig serializationConfig = mapper.getSerializationConfig();
        serializationConfig.set(SerializationConfig.Feature.INDENT_OUTPUT, true);
        serializationConfig.set(SerializationConfig.Feature.AUTO_DETECT_FIELDS, true);
        serializationConfig.set(SerializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS, true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] serializedBytes = null;
        try {
            mapper.writeValue((OutputStream)baos, data);
            serializedBytes = baos.toByteArray();
            if (record.getBooleanField("enableCompression", false)) {
                serializedBytes = GZipCompressionUtil.compress(serializedBytes);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception during data serialization. Will not write to zk. Data (first 1k): " + new String(baos.toByteArray()).substring(0, 1024)), (Throwable)e);
            throw new HelixException(e);
        }
        if (serializedBytes.length > 1024000) {
            logger.error((Object)("Data size larger than 1M, ZNRecord.id: " + record.getId() + ". Will not write to zk. Data (first 1k): " + new String(serializedBytes).substring(0, 1024)));
            throw new HelixException("Data size larger than 1M, ZNRecord.id: " + record.getId());
        }
        return serializedBytes;
    }

    public Object deserialize(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        DeserializationConfig deserializationConfig = mapper.getDeserializationConfig();
        deserializationConfig.set(DeserializationConfig.Feature.AUTO_DETECT_FIELDS, true);
        deserializationConfig.set(DeserializationConfig.Feature.AUTO_DETECT_SETTERS, true);
        deserializationConfig.set(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        try {
            if (GZipCompressionUtil.isCompressed(bytes)) {
                byte[] uncompressedBytes = GZipCompressionUtil.uncompress(bais);
                bais = new ByteArrayInputStream(uncompressedBytes);
            }
            ZNRecord zn = (ZNRecord)mapper.readValue((InputStream)bais, ZNRecord.class);
            return zn;
        }
        catch (Exception e) {
            logger.error((Object)("Exception during deserialization of bytes: " + new String(bytes)), (Throwable)e);
            return null;
        }
    }
}

