/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration;

import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.workbench.jcr2vfsmigration.common.FileManager;
import org.drools.workbench.jcr2vfsmigration.config.VfsImportConfig;
import org.drools.workbench.jcr2vfsmigration.util.MigrationPathManager;
import org.drools.workbench.jcr2vfsmigration.vfsImport.ModuleAssetImporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class VfsImporter {
    private static final Logger logger = LoggerFactory.getLogger(VfsImporter.class);
    @Inject
    protected VfsImportConfig vfsImportConfig;
    @Inject
    private FileManager fileManager;
    @Inject
    protected MigrationPathManager migrationPathManager;
    @Inject
    protected ModuleAssetImporter moduleAssetImporter;

    public boolean parseArgs(String[] args) {
        boolean ok = this.vfsImportConfig.parseArgs(args);
        if (ok) {
            this.fileManager.setExportTempDir(this.vfsImportConfig.getImportTempDir());
        }
        return ok;
    }

    public void importAll() {
        logger.info("VFS import started. Reading from import directory {}.", (Object)this.vfsImportConfig.getImportTempDir().getAbsolutePath());
        String vfsRepoCanonicalPath = this.getVfsRepoCanonicalPath(this.vfsImportConfig);
        this.migrationPathManager.setRepoName(this.vfsImportConfig.getOutputRepoName(), vfsRepoCanonicalPath);
        this.moduleAssetImporter.importAll();
    }

    private String getVfsRepoCanonicalPath(VfsImportConfig config) {
        try {
            return config.getOutputVfsRepository().getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException("Can't determine canonical path for output VFS repository!", e);
        }
    }
}

