/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.authz;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.Role;
import org.uberfire.security.authz.AuthorizationPolicy;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.impl.authz.AuthorizationPolicyBuilder;

public class AuthorizationPolicyMarshaller {
    private static final String ROLE = "role";
    private static final String GROUP = "group";
    private static final String PERMISSION = "permission";
    private static final String PRIORITY = "priority";
    private static final String HOME = "home";
    private static final String DESCRIPTION = "description";

    public void read(AuthorizationPolicyBuilder builder, Map ... input) {
        for (Map m : input) {
            m.forEach((x, y) -> this.read(builder, x.toString(), y.toString()));
        }
    }

    public void read(AuthorizationPolicyBuilder builder, String key, String value) {
        String attr;
        List<String> tokens = this.split(key);
        String type = tokens.get(0);
        String typeId = tokens.get(1);
        switch (type) {
            case "role": {
                builder.role(typeId);
                break;
            }
            case "group": {
                builder.group(typeId);
                break;
            }
            default: {
                throw new IllegalArgumentException("Key must start either with 'role' or 'group': " + key);
            }
        }
        switch (attr = tokens.get(2)) {
            case "description": {
                builder.description(value);
                break;
            }
            case "home": {
                builder.home(value);
                break;
            }
            case "priority": {
                builder.priority(Integer.parseInt(value));
                break;
            }
            case "permission": {
                String permission = tokens.get(3);
                if (permission.length() == 0) {
                    throw new IllegalArgumentException("Permission is incomplete: " + key);
                }
                boolean granted = Boolean.parseBoolean(value);
                builder.permission(permission, Boolean.valueOf(granted));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown key: " + key);
            }
        }
    }

    public void write(AuthorizationPolicy policy, Map out) {
        for (Role subject : policy.getRoles()) {
            this.write(subject, policy.getHomePerspective(subject), out);
            this.write(subject, policy.getPriority(subject), out);
            this.write(subject, policy.getPermissions(subject), out);
        }
        for (Role subject : policy.getGroups()) {
            this.write((Group)subject, policy.getHomePerspective((Group)subject), out);
            this.write((Group)subject, policy.getPriority((Group)subject), out);
            this.write((Group)subject, policy.getPermissions((Group)subject), out);
        }
    }

    public void write(Role role, String homePerspectiveId, Map out) {
        String key = "role." + role.getName() + "." + HOME;
        out.remove(key);
        if (homePerspectiveId != null) {
            out.put(key, homePerspectiveId);
        }
    }

    public void write(Role role, int priority, Map out) {
        String key = "role." + role.getName() + "." + PRIORITY;
        out.put(key, Integer.toString(priority));
    }

    public void write(Role role, PermissionCollection permissions, Map out) {
        for (Permission p : permissions.collection()) {
            boolean granted = p.getResult() != null && p.getResult().equals((Object)AuthorizationResult.ACCESS_GRANTED);
            String key = "role." + role.getName() + "." + PERMISSION + "." + p.getName();
            out.put(key, Boolean.toString(granted));
        }
    }

    public void write(Group group, String homePerspectiveId, Map out) {
        String key = "group." + group.getName() + "." + HOME;
        out.remove(key);
        if (homePerspectiveId != null) {
            out.put(key, homePerspectiveId);
        }
    }

    public void write(Group group, int priority, Map out) {
        String key = "group." + group.getName() + "." + PRIORITY;
        out.put(key, Integer.toString(priority));
    }

    public void write(Group group, PermissionCollection permissions, Map out) {
        for (Permission p : permissions.collection()) {
            boolean granted = p.getResult() != null && p.getResult().equals((Object)AuthorizationResult.ACCESS_GRANTED);
            String key = "group." + group.getName() + "." + PERMISSION + "." + p.getName();
            out.put(key, Boolean.toString(granted));
        }
    }

    public List<String> split(String key) {
        String[] tokens;
        String _key = key.endsWith(".*") ? key.substring(0, key.length() - 2) : key;
        ArrayList<String> result = new ArrayList<String>();
        for (String token : tokens = _key.split("\\.")) {
            if (token.length() == 0) {
                throw new IllegalArgumentException("Empty token not allowed: " + key);
            }
            if (result.size() < 4) {
                result.add(token);
                continue;
            }
            result.set(3, (String)result.get(3) + "." + token);
        }
        if (result.size() < 3) {
            throw new IllegalArgumentException("Incomplete key: " + key);
        }
        return result;
    }
}

