/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.lucene;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.util.CharArraySet;
import org.uberfire.ext.metadata.backend.lucene.LuceneConfig;
import org.uberfire.ext.metadata.backend.lucene.analyzer.FilenameAnalyzer;
import org.uberfire.ext.metadata.backend.lucene.fields.FieldFactory;
import org.uberfire.ext.metadata.backend.lucene.fields.SimpleFieldFactory;
import org.uberfire.ext.metadata.backend.lucene.index.directory.DirectoryFactory;
import org.uberfire.ext.metadata.backend.lucene.index.directory.DirectoryType;
import org.uberfire.ext.metadata.backend.lucene.metamodel.InMemoryMetaModelStore;
import org.uberfire.ext.metadata.backend.lucene.metamodel.NullMetaModelStore;
import org.uberfire.ext.metadata.engine.MetaModelStore;

public final class LuceneConfigBuilder {
    private MetaModelStore metaModelStore;
    private FieldFactory fieldFactory;
    private DirectoryType type;
    private Analyzer analyzer;
    private Map<String, Analyzer> analyzers;

    public LuceneConfigBuilder withInMemoryMetaModelStore() {
        this.metaModelStore = new InMemoryMetaModelStore();
        return this;
    }

    public LuceneConfigBuilder withoutMemoryMetaModel() {
        this.metaModelStore = new NullMetaModelStore();
        return this;
    }

    public LuceneConfigBuilder withDefaultFieldFactory() {
        this.fieldFactory = new SimpleFieldFactory();
        return this;
    }

    public LuceneConfigBuilder usingAnalyzers(Map<String, Analyzer> analyzers) {
        this.analyzers = analyzers;
        return this;
    }

    public LuceneConfigBuilder usingFieldFactory(FieldFactory fieldFactory) {
        this.fieldFactory = fieldFactory;
        return this;
    }

    public LuceneConfigBuilder useDirectoryBasedIndex() {
        return this;
    }

    public LuceneConfigBuilder useInMemoryDirectory() {
        this.type = DirectoryType.INMEMORY;
        return this;
    }

    public LuceneConfigBuilder useMMapDirectory() {
        this.type = DirectoryType.MMAP;
        return this;
    }

    public LuceneConfigBuilder useNIODirectory() {
        this.type = DirectoryType.NIO;
        return this;
    }

    public LuceneConfig build() {
        if (this.metaModelStore == null) {
            this.withoutMemoryMetaModel();
        }
        if (this.fieldFactory == null) {
            this.withDefaultFieldFactory();
        }
        if (this.type == null) {
            this.withDefaultDirectory();
        }
        if (this.analyzers == null) {
            this.withDefaultAnalyzers();
        }
        if (this.analyzer == null) {
            this.withDefaultAnalyzer();
        }
        return new LuceneConfig(this.metaModelStore, this.fieldFactory, new DirectoryFactory(this.type, this.analyzer), this.analyzer);
    }

    public void withDefaultDirectory() {
        this.useNIODirectory();
    }

    public void withDefaultAnalyzers() {
        this.analyzers = new HashMap<String, Analyzer>();
        this.analyzers.put("filename", new FilenameAnalyzer());
    }

    public void withDefaultAnalyzer() {
        this.analyzer = new PerFieldAnalyzerWrapper((Analyzer)new StandardAnalyzer(CharArraySet.EMPTY_SET), (Map)new HashMap<String, Analyzer>(){
            {
                this.putAll(LuceneConfigBuilder.this.analyzers);
            }
        });
    }
}

