/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.vfsImport.asset;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.drools.workbench.jcr2vfsmigration.util.MigrationPathManager;
import org.drools.workbench.jcr2vfsmigration.vfsImport.asset.FactModelImporter;
import org.drools.workbench.jcr2vfsmigration.xml.model.Module;
import org.drools.workbench.jcr2vfsmigration.xml.model.ModuleType;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.DataModelAsset;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.XmlAsset;
import org.guvnor.common.services.project.service.ProjectService;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.definition.type.Role;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.DataModelImpl;
import org.kie.workbench.common.services.datamodeller.util.DriverUtils;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.io.IOService;

@RunWith(value=MockitoJUnitRunner.class)
public class FactModelImporterTest {
    @Mock
    private IOService ioService;
    @Mock
    private MigrationPathManager migrationPathManager;
    @Mock
    private DataModelerService modelerService;
    @Mock
    private ProjectService<KieProject> projectService;
    @InjectMocks
    FactModelImporter factModelImporter = new FactModelImporter();
    private static Map<String, AnnotationDefinition> annotationDefinitions = new HashMap<String, AnnotationDefinition>();

    @Test
    public void testFactsImportGeneratedModel() {
        Module xmlModule = this.buildModule();
        DataModelAsset xmlAsset = this.buildDataModelAsset();
        Path path = (Path)Mockito.mock(Path.class);
        KieProject project = (KieProject)Mockito.mock(KieProject.class);
        Mockito.when((Object)this.migrationPathManager.generatePathForAsset(xmlModule, (XmlAsset)xmlAsset, xmlAsset.getAssetType().toString())).thenReturn((Object)path);
        Mockito.when((Object)this.projectService.resolveProject(path)).thenReturn((Object)project);
        Mockito.when((Object)this.modelerService.getAnnotationDefinitions()).thenReturn(annotationDefinitions);
        this.factModelImporter.importAsset(xmlModule, xmlAsset, null);
        DataModel expectedDataModel = this.buildExpectedDataModel();
        ((DataModelerService)Mockito.verify((Object)this.modelerService, (VerificationMode)Mockito.times((int)1))).saveModel((DataModel)Mockito.eq((Object)expectedDataModel), (KieProject)Mockito.eq((Object)project));
    }

    private Module buildModule() {
        Module module = new Module(ModuleType.NORMAL, "uuid-test-module", "test-module", "test-user", "last checkin comment", new Date(), "org.kie.test", null, null, null, null);
        return module;
    }

    private DataModelAsset buildDataModelAsset() {
        DataModelAsset dataModelAsset = new DataModelAsset("TestFact", "drl", "test-user", "last checkin comment", new Date());
        DataModelAsset.DataModelObject dataModelObject = dataModelAsset.addDataModelObject("TestFact", "java.lang.Object");
        dataModelObject.addObjectAnnotation("Role", "value", Role.Type.EVENT.name());
        dataModelObject.addObjectProperty("field1", "java.lang.String");
        return dataModelAsset;
    }

    private DataModel buildExpectedDataModel() {
        DataModelImpl dataModel = new DataModelImpl();
        DataObject dataObject = dataModel.addDataObject("org.kie.test", "TestFact");
        dataObject.setSuperClassName("java.lang.Object");
        AnnotationImpl annotation = new AnnotationImpl(annotationDefinitions.get(Role.class.getName()));
        annotation.setValue("value", (Object)Role.Type.EVENT.name());
        dataObject.addAnnotation((Annotation)annotation);
        dataObject.addProperty("field1", "java.lang.String");
        return dataModel;
    }

    static {
        annotationDefinitions.put(Role.class.getName(), DriverUtils.buildAnnotationDefinition(Role.class));
    }
}

