/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query.response;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.ResponseBuilder;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringStringPageRow;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KProperty;
import org.uberfire.paging.PageResponse;

public class RuleNameResponseBuilder
implements ResponseBuilder {
    @Override
    public PageResponse<RefactoringPageRow> buildResponse(int pageSize, int startRow, List<KObject> kObjects) {
        int hits = kObjects.size();
        PageResponse response = new PageResponse();
        List<RefactoringPageRow> result = this.buildResponse(kObjects);
        response.setTotalRowSize(hits);
        response.setPageRowList(result);
        response.setTotalRowSizeExact(true);
        response.setStartRowIndex(startRow);
        response.setLastPage(pageSize * startRow + 2 >= hits);
        return response;
    }

    @Override
    public List<RefactoringPageRow> buildResponse(List<KObject> kObjects) {
        ArrayList<RefactoringPageRow> result = new ArrayList<RefactoringPageRow>(kObjects.size());
        HashSet<String> uniqueRuleNames = new HashSet<String>();
        for (KObject kObject : kObjects) {
            Set<String> ruleNames = this.getRuleNamesFromKObject(kObject);
            uniqueRuleNames.addAll(ruleNames);
        }
        for (String ruleName : uniqueRuleNames) {
            RefactoringStringPageRow row = new RefactoringStringPageRow();
            row.setValue((Object)ruleName);
            result.add((RefactoringPageRow)row);
        }
        return result;
    }

    private Set<String> getRuleNamesFromKObject(KObject kObject) {
        HashSet<String> ruleNames = new HashSet<String>();
        if (kObject == null) {
            return ruleNames;
        }
        for (KProperty property : kObject.getProperties()) {
            if (!property.getName().equals(ResourceType.RULE.toString())) continue;
            ruleNames.add(property.getValue().toString());
        }
        return ruleNames;
    }
}

