/*
 * Decompiled with CFR 0.152.
 */
package org.kie.uberfire.social.activities.persistence;

import com.google.gson.Gson;
import org.kie.uberfire.social.activities.model.SocialUser;
import org.kie.uberfire.social.activities.persistence.SocialUserCachePersistence;
import org.kie.uberfire.social.activities.server.SocialUserServicesExtendedBackEndImpl;
import org.uberfire.backend.server.UserServicesImpl;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class SocialUserInstancePersistence
extends SocialUserCachePersistence {
    public SocialUserInstancePersistence(SocialUserServicesExtendedBackEndImpl userServicesBackend, UserServicesImpl userServices, IOService ioService, Gson gson) {
        super(userServicesBackend, userServices, ioService, gson);
    }

    @Override
    public void updateUsers(SocialUser ... users) {
        for (SocialUser user : users) {
            this.usersCache.put(user.getUserName(), user);
            Path userFile = this.userServicesBackend.buildPath("social-files", user.getUserName());
            try {
                this.ioService.startBatch(userFile.getFileSystem());
                this.ioService.write(userFile, this.gson.toJson((Object)user), new OpenOption[0]);
            }
            catch (Exception e) {
                throw new SocialUserCachePersistence.ErrorUpdatingUsers(e);
            }
            finally {
                this.ioService.endBatch();
            }
        }
    }

    @Override
    String syncUserNamesCacheAndFile(String userName) {
        if (this.usersNamesCache.contains(userName)) {
            return userName;
        }
        this.usersNamesCache.add(userName);
        SocialUser socialUser = this.createOrRetrieveUserData(userName);
        this.usersCache.put(userName, socialUser);
        this.writeUserNamesOnFile(this.usersNamesCache);
        return userName;
    }
}

