/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.core.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import org.kie.workbench.common.services.datamodeller.core.JavaClass;
import org.kie.workbench.common.services.datamodeller.core.JavaTypeKind;
import org.kie.workbench.common.services.datamodeller.core.Method;
import org.kie.workbench.common.services.datamodeller.core.Visibility;
import org.kie.workbench.common.services.datamodeller.core.impl.AbstractJavaType;

public class JavaClassImpl
extends AbstractJavaType
implements JavaClass {
    private String superClassName;
    private List<String> interfaces = new ArrayList<String>();
    private List<JavaClass> nestedClasses = new ArrayList<JavaClass>();
    private List<Method> methods = new ArrayList<Method>();
    boolean _static = false;
    boolean _final = false;
    boolean _abstract = false;

    public JavaClassImpl() {
    }

    public JavaClassImpl(String packageName, String name) {
        this(packageName, name, Visibility.PUBLIC);
    }

    public JavaClassImpl(String packageName, String name, Visibility visibility) {
        super(packageName, name, JavaTypeKind.CLASS, visibility);
    }

    public JavaClassImpl(String packageName, String name, Visibility visibility, boolean isAbstract, boolean isFinal) {
        this(packageName, name, visibility);
        this._abstract = isAbstract;
        this._final = isFinal;
    }

    @Override
    public boolean isAbstract() {
        return this._abstract;
    }

    @Override
    public boolean isFinal() {
        return this._final;
    }

    @Override
    public boolean isStatic() {
        return this._static;
    }

    @Override
    public List<JavaClass> getNestedClasses() {
        return this.nestedClasses;
    }

    @Override
    public JavaClass addNestedClass(JavaClass javaClass) {
        if (javaClass == null) {
            return null;
        }
        ListIterator<JavaClass> iterator = this.nestedClasses.listIterator();
        while (iterator.hasNext()) {
            JavaClass nestedClass = (JavaClass)iterator.next();
            if (!nestedClass.getName().equals(javaClass.getName())) continue;
            iterator.remove();
            break;
        }
        this.nestedClasses.add(javaClass);
        return javaClass;
    }

    @Override
    public JavaClass removeNestedClass(JavaClass javaClass) {
        boolean removed = this.nestedClasses.remove(javaClass);
        return removed ? javaClass : null;
    }

    @Override
    public List<Method> getMethods() {
        return this.methods;
    }

    @Override
    public Method addMethod(Method method) {
        ListIterator<Method> iterator = this.methods.listIterator();
        while (iterator.hasNext()) {
            Method existingMethod = (Method)iterator.next();
            if (!existingMethod.getName().equals(method.getName()) || !existingMethod.getParameters().equals(method.getParameters())) continue;
            iterator.remove();
            break;
        }
        this.methods.add(method);
        return method;
    }

    @Override
    public Method getMethod(String name, List<String> parameterTypes) {
        for (Method method : this.methods) {
            if (!method.getName().equals(name)) continue;
            if (method.getParameters() == null && parameterTypes == null) {
                return method;
            }
            if (!method.getParameters().stream().map(p -> p.getType().getName()).collect(Collectors.toList()).equals(parameterTypes)) continue;
            return method;
        }
        return null;
    }

    @Override
    public Method removeMethod(Method method) {
        return this.methods.remove(method) ? null : method;
    }

    @Override
    public String getSuperClassName() {
        return this.superClassName;
    }

    @Override
    public void setSuperClassName(String superClassName) {
        this.superClassName = superClassName;
    }

    @Override
    public final boolean isClass() {
        return true;
    }

    @Override
    public List<String> getInterfaces() {
        return this.interfaces;
    }

    @Override
    public void addInterface(String interfaceDefinition) {
        this.interfaces.add(interfaceDefinition);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JavaClassImpl javaClass = (JavaClassImpl)o;
        if (this._static != javaClass._static) {
            return false;
        }
        if (this._final != javaClass._final) {
            return false;
        }
        if (this._abstract != javaClass._abstract) {
            return false;
        }
        if (this.superClassName != null ? !this.superClassName.equals(javaClass.superClassName) : javaClass.superClassName != null) {
            return false;
        }
        if (this.interfaces != null ? !this.interfaces.equals(javaClass.interfaces) : javaClass.interfaces != null) {
            return false;
        }
        if (this.nestedClasses != null ? !this.nestedClasses.equals(javaClass.nestedClasses) : javaClass.nestedClasses != null) {
            return false;
        }
        return !(this.methods == null ? javaClass.methods != null : !this.methods.equals(javaClass.methods));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = ~(~result);
        result = 31 * result + (this.superClassName != null ? this.superClassName.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.interfaces != null ? this.interfaces.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.nestedClasses != null ? this.nestedClasses.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.methods != null ? this.methods.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this._static ? 1 : 0);
        result = ~(~result);
        result = 31 * result + (this._final ? 1 : 0);
        result = ~(~result);
        result = 31 * result + (this._abstract ? 1 : 0);
        result = ~(~result);
        return result;
    }
}

