/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.util;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.drools.core.base.ClassTypeResolver;
import org.jboss.forge.roaster.model.Member;
import org.jboss.forge.roaster.model.Type;
import org.jboss.forge.roaster.model.Visibility;
import org.jboss.forge.roaster.model.VisibilityScoped;
import org.jboss.forge.roaster.model.source.Import;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.AnnotationRetention;
import org.kie.workbench.common.services.datamodeller.core.AnnotationValuePairDefinition;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationDefinitionImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationValuePairDefinitionImpl;
import org.kie.workbench.common.services.datamodeller.driver.ModelDriverException;
import org.kie.workbench.common.services.datamodeller.util.NamingUtils;
import org.kie.workbench.common.services.datamodeller.util.PortableStringUtils;
import org.kie.workbench.common.services.datamodeller.util.StringEscapeUtils;

public class DriverUtils {
    public static ClassTypeResolver createClassTypeResolver(JavaSource javaSource, ClassLoader classLoader) {
        JavaClassSource javaClassSource;
        List innerTypes;
        String packageName;
        HashSet<String> classImports = new HashSet<String>();
        List imports = javaSource.getImports();
        if (imports != null) {
            for (Import currentImport : imports) {
                String importName = currentImport.getQualifiedName();
                if (currentImport.isWildcard()) {
                    importName = importName + ".*";
                }
                classImports.add(importName);
            }
        }
        if ((packageName = javaSource.getPackage()) != null && !"".equals(packageName)) {
            classImports.add(packageName + ".*");
        }
        if (javaSource instanceof JavaClassSource && (innerTypes = (javaClassSource = (JavaClassSource)javaSource).getNestedTypes()) != null) {
            for (JavaSource type : innerTypes) {
                classImports.add(packageName + "." + javaClassSource.getName() + "." + type.getName());
            }
        }
        return new ClassTypeResolver(classImports, classLoader);
    }

    public static ClassTypeResolver createClassTypeResolver(ClassLoader classLoader) {
        return new ClassTypeResolver(new HashSet(), classLoader);
    }

    public static Object[] isSimpleGeneric(Type type, ClassTypeResolver classTypeResolver) throws ModelDriverException {
        Object[] result = new Object[]{false, null, null};
        if (type.isArray() || type.isPrimitive() || !type.isParameterized() || type.isParameterized() && type.getTypeArguments().size() != 1) {
            return result;
        }
        Type argument = (Type)type.getTypeArguments().get(0);
        if (!DriverUtils.isSimpleClass(argument)) {
            return result;
        }
        try {
            String outerClass = classTypeResolver.getFullTypeName(type.getName());
            String argumentClass = classTypeResolver.getFullTypeName(argument.getName());
            result[0] = true;
            result[1] = outerClass;
            result[2] = argumentClass;
            return result;
        }
        catch (ClassNotFoundException e) {
            throw new ModelDriverException("Class could not be resolved for name: " + type.getName() + ". " + e.getMessage(), e);
        }
    }

    public static boolean isManagedType(Type type, ClassTypeResolver classTypeResolver) throws ModelDriverException {
        if (type.isPrimitive()) {
            return true;
        }
        if (type.isArray()) {
            return false;
        }
        if (type.isParameterized() && type.getTypeArguments().size() > 1) {
            return false;
        }
        try {
            Class clazz = classTypeResolver.resolveType(type.getName());
            if (clazz.isEnum() || clazz.isAnonymousClass() || clazz.isLocalClass() || clazz.isMemberClass()) {
                return false;
            }
            if (type.isParameterized()) {
                Class bag = classTypeResolver.resolveType(type.getName());
                if (!Collection.class.isAssignableFrom(bag)) {
                    return false;
                }
                return DriverUtils.isSimpleClass((Type)type.getTypeArguments().get(0));
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            throw new ModelDriverException("Class could not be resolved for name: " + type.getName() + ". " + e.getMessage(), e);
        }
    }

    public static boolean isSimpleClass(Type<?> type) {
        return !type.isArray() && !type.isPrimitive() && !type.isParameterized();
    }

    public static boolean equalsType(Type type, String fullClassName, boolean multiple, String fullBagClassName, ClassTypeResolver classTypeResolver) throws Exception {
        if (type.isArray()) {
            return false;
        }
        if (type.isPrimitive()) {
            return !multiple && fullClassName.equals(type.getName());
        }
        if (DriverUtils.isSimpleClass(type)) {
            String currentClassName = classTypeResolver.getFullTypeName(type.getName());
            return !multiple && fullClassName.equals(currentClassName);
        }
        Object[] simpleGenerics = DriverUtils.isSimpleGeneric(type, classTypeResolver);
        if (multiple && Boolean.TRUE.equals(simpleGenerics[0]) && DriverUtils.isManagedType(type, classTypeResolver)) {
            String currentBag = (String)simpleGenerics[1];
            currentBag = classTypeResolver.getFullTypeName(currentBag);
            String currentClassName = (String)simpleGenerics[2];
            currentClassName = classTypeResolver.getFullTypeName(currentClassName);
            return fullBagClassName.equals(currentBag) && fullClassName.equals(currentClassName);
        }
        return false;
    }

    public static int buildModifierRepresentation(Member<?> member) {
        int result = 0;
        result = DriverUtils.addModifierRepresentation(result, member);
        result = DriverUtils.addModifierRepresentation(result, member);
        return result;
    }

    public static org.kie.workbench.common.services.datamodeller.core.Visibility buildVisibility(int javaSpecModifiers) {
        if (Modifier.isPublic(javaSpecModifiers)) {
            return org.kie.workbench.common.services.datamodeller.core.Visibility.PUBLIC;
        }
        if (Modifier.isProtected(javaSpecModifiers)) {
            return org.kie.workbench.common.services.datamodeller.core.Visibility.PROTECTED;
        }
        if (Modifier.isPrivate(javaSpecModifiers)) {
            return org.kie.workbench.common.services.datamodeller.core.Visibility.PRIVATE;
        }
        return org.kie.workbench.common.services.datamodeller.core.Visibility.PACKAGE_PRIVATE;
    }

    public static org.kie.workbench.common.services.datamodeller.core.Visibility buildVisibility(Visibility visibility) {
        switch (visibility) {
            case PUBLIC: {
                return org.kie.workbench.common.services.datamodeller.core.Visibility.PUBLIC;
            }
            case PROTECTED: {
                return org.kie.workbench.common.services.datamodeller.core.Visibility.PROTECTED;
            }
            case PRIVATE: {
                return org.kie.workbench.common.services.datamodeller.core.Visibility.PRIVATE;
            }
        }
        return org.kie.workbench.common.services.datamodeller.core.Visibility.PACKAGE_PRIVATE;
    }

    public static Visibility buildVisibility(org.kie.workbench.common.services.datamodeller.core.Visibility visibility) {
        switch (visibility) {
            case PUBLIC: {
                return Visibility.PUBLIC;
            }
            case PROTECTED: {
                return Visibility.PROTECTED;
            }
            case PRIVATE: {
                return Visibility.PRIVATE;
            }
        }
        return Visibility.PACKAGE_PRIVATE;
    }

    public static AnnotationRetention buildRetention(RetentionPolicy retention) {
        switch (retention) {
            case RUNTIME: {
                return AnnotationRetention.RUNTIME;
            }
            case SOURCE: {
                return AnnotationRetention.SOURCE;
            }
        }
        return AnnotationRetention.CLASS;
    }

    public static org.kie.workbench.common.services.datamodeller.core.ElementType buildElementType(ElementType elementType) {
        switch (elementType) {
            case TYPE: {
                return org.kie.workbench.common.services.datamodeller.core.ElementType.TYPE;
            }
            case FIELD: {
                return org.kie.workbench.common.services.datamodeller.core.ElementType.FIELD;
            }
            case METHOD: {
                return org.kie.workbench.common.services.datamodeller.core.ElementType.METHOD;
            }
            case PARAMETER: {
                return org.kie.workbench.common.services.datamodeller.core.ElementType.PARAMETER;
            }
            case CONSTRUCTOR: {
                return org.kie.workbench.common.services.datamodeller.core.ElementType.CONSTRUCTOR;
            }
            case LOCAL_VARIABLE: {
                return org.kie.workbench.common.services.datamodeller.core.ElementType.LOCAL_VARIABLE;
            }
            case ANNOTATION_TYPE: {
                return org.kie.workbench.common.services.datamodeller.core.ElementType.ANNOTATION_TYPE;
            }
            case PACKAGE: {
                return org.kie.workbench.common.services.datamodeller.core.ElementType.PACKAGE;
            }
        }
        return null;
    }

    public static AnnotationValuePairDefinition.ValuePairType buildValuePairType(Class cls) {
        if (cls.isEnum()) {
            return AnnotationValuePairDefinition.ValuePairType.ENUM;
        }
        if (cls.isAnnotation()) {
            return AnnotationValuePairDefinition.ValuePairType.ANNOTATION;
        }
        if (cls.getName().equals(String.class.getName())) {
            return AnnotationValuePairDefinition.ValuePairType.STRING;
        }
        if (NamingUtils.isPrimitiveTypeId(cls.getName())) {
            return AnnotationValuePairDefinition.ValuePairType.PRIMITIVE;
        }
        return AnnotationValuePairDefinition.ValuePairType.CLASS;
    }

    public static boolean isAnnotationMember(Class cls, Method method) {
        return cls.equals(method.getDeclaringClass()) && Modifier.isPublic(method.getModifiers()) && (method.getParameterTypes() == null || method.getParameterTypes().length == 0) && DriverUtils.isAnnotationReturnType(method.getReturnType());
    }

    public static boolean isAnnotationReturnType(Class cls) {
        Class<?> targetType = cls;
        if (cls.isArray() && (targetType = cls.getComponentType()).isArray()) {
            return false;
        }
        return targetType.isAnnotation() || targetType.isEnum() || targetType.isPrimitive() || !targetType.isAnonymousClass() && !targetType.isLocalClass();
    }

    public static boolean isValidAnnotationBaseReturnType(Class cls) {
        return cls.isAnnotation() || cls.isEnum() || NamingUtils.isPrimitiveTypeId(cls.getName()) || !cls.isAnonymousClass() && !cls.isLocalClass();
    }

    public static void copyAnnotationRetention(Class annotationClass, AnnotationDefinition annotationDefinition) {
        if (annotationClass.isAnnotationPresent(Retention.class)) {
            Retention retentionAnnotation = annotationClass.getAnnotation(Retention.class);
            annotationDefinition.setRetention(DriverUtils.buildRetention(retentionAnnotation.value()));
        }
    }

    public static void copyAnnotationTarget(Class annotationClass, AnnotationDefinition annotationDefinition) {
        if (annotationClass.isAnnotationPresent(Target.class)) {
            Target targetAnnotation = annotationClass.getAnnotation(Target.class);
            ElementType[] targets = targetAnnotation.value();
            if (targets != null && targets.length > 0) {
                for (int i = 0; i < targets.length; ++i) {
                    annotationDefinition.addTarget(DriverUtils.buildElementType(targets[i]));
                }
            } else {
                annotationDefinition.addTarget(org.kie.workbench.common.services.datamodeller.core.ElementType.UNDEFINED);
            }
        }
    }

    public static int buildModifierRepresentation(JavaClassSource classSource) {
        return DriverUtils.addModifierRepresentation(0, (VisibilityScoped)classSource);
    }

    public static int addModifierRepresentation(int modifiers, Member<?> member) {
        if (member != null) {
            if (member.isStatic()) {
                modifiers |= 8;
            }
            if (member.isFinal()) {
                modifiers |= 0x10;
            }
        }
        return modifiers;
    }

    public static int addModifierRepresentation(int modifiers, VisibilityScoped visibilityScoped) {
        if (visibilityScoped != null) {
            if (visibilityScoped.isPublic()) {
                modifiers |= 1;
            }
            if (visibilityScoped.isProtected()) {
                modifiers |= 4;
            }
            if (visibilityScoped.isPrivate()) {
                modifiers |= 2;
            }
        }
        return modifiers;
    }

    public static AnnotationDefinition buildAnnotationDefinition(Class cls) {
        if (!cls.isAnnotation()) {
            return null;
        }
        AnnotationDefinitionImpl annotationDefinition = new AnnotationDefinitionImpl(NamingUtils.normalizeClassName(cls.getName()));
        DriverUtils.copyAnnotationRetention(cls, annotationDefinition);
        DriverUtils.copyAnnotationTarget(cls, annotationDefinition);
        Method[] methods = cls.getMethods();
        boolean isArray = false;
        for (int i = 0; methods != null && i < methods.length; ++i) {
            ?[] enumConstants;
            AnnotationValuePairDefinitionImpl valuePairDefinition;
            Method method = methods[i];
            if (!DriverUtils.isAnnotationMember(cls, method)) continue;
            Class<?> returnType = method.getReturnType();
            isArray = returnType.isArray();
            if (isArray) {
                returnType = returnType.getComponentType();
            }
            if ((valuePairDefinition = new AnnotationValuePairDefinitionImpl(method.getName(), NamingUtils.normalizeClassName(returnType.getName()), DriverUtils.buildValuePairType(returnType), isArray, method.getDefaultValue() != null ? method.getDefaultValue().toString() : null)).isAnnotation()) {
                valuePairDefinition.setAnnotationDefinition(DriverUtils.buildAnnotationDefinition(returnType));
            }
            if (valuePairDefinition.isEnum() && (enumConstants = returnType.getEnumConstants()) != null) {
                String[] strEnumConstants = new String[enumConstants.length];
                for (int j = 0; j < enumConstants.length; ++j) {
                    strEnumConstants[j] = enumConstants[j].toString();
                }
                valuePairDefinition.setEnumValues(strEnumConstants);
            }
            annotationDefinition.addValuePair(valuePairDefinition);
        }
        return annotationDefinition;
    }

    public static String encodePrimitiveArrayValue(AnnotationValuePairDefinition valuePairDefinition, Object value) {
        if (value == null) {
            return null;
        }
        ArrayList<Object> encodedValues = new ArrayList<Object>();
        if (value instanceof List) {
            for (Object item : (List)value) {
                String encodedItem;
                if (item == null || (encodedItem = DriverUtils.encodePrimitiveValue(valuePairDefinition, item)) == null) continue;
                encodedValues.add(encodedItem);
            }
        } else {
            String encodedItem = DriverUtils.encodePrimitiveValue(valuePairDefinition, value);
            if (encodedItem != null) {
                encodedValues.add(encodedItem);
            }
        }
        return DriverUtils.toEncodedArray(encodedValues);
    }

    public static String encodePrimitiveValue(AnnotationValuePairDefinition valuePairDefinition, Object value) {
        if (value == null) {
            return null;
        }
        StringBuilder encodedValue = new StringBuilder();
        if (NamingUtils.isCharId(valuePairDefinition.getClassName()) || Character.class.getName().equals(valuePairDefinition.getClassName())) {
            String strValue = value.toString();
            if (StringEscapeUtils.isSingleQuoted(strValue)) {
                encodedValue.append(strValue);
            } else {
                encodedValue.append("'");
                encodedValue.append(value.toString());
                encodedValue.append("'");
            }
        } else if (NamingUtils.isLongId(valuePairDefinition.getClassName()) || Long.class.getName().equals(valuePairDefinition.getClassName())) {
            encodedValue.append(value.toString());
            encodedValue.append("L");
        } else if (NamingUtils.isFloatId(valuePairDefinition.getClassName()) || Float.class.getName().equals(valuePairDefinition.getClassName())) {
            encodedValue.append(value.toString());
            encodedValue.append("f");
        } else if (NamingUtils.isDoubleId(valuePairDefinition.getClassName()) || Double.class.getName().equals(valuePairDefinition.getClassName())) {
            encodedValue.append(value.toString());
            encodedValue.append("d");
        } else if (NamingUtils.isByteId(valuePairDefinition.getClassName()) || Byte.class.getName().equals(valuePairDefinition.getClassName())) {
            encodedValue.append("(byte)");
            encodedValue.append(value.toString());
        } else {
            encodedValue.append(value.toString());
        }
        return encodedValue.toString();
    }

    public static String encodeClassValue(String value) {
        if (value == null) {
            return value;
        }
        if (value.endsWith(".class")) {
            return value;
        }
        return value + ".class";
    }

    public static String encodeClassArrayValue(Object value) {
        if (value == null) {
            return null;
        }
        ArrayList<Object> encodedValues = new ArrayList<Object>();
        if (value instanceof List) {
            for (Object item : (List)value) {
                String encodedItem;
                if (item == null || (encodedItem = DriverUtils.encodeClassValue(item.toString())) == null) continue;
                encodedValues.add(encodedItem);
            }
        } else {
            String encodedItem = DriverUtils.encodeClassValue(value.toString());
            if (encodedItem != null) {
                encodedValues.add(encodedItem);
            }
        }
        return DriverUtils.toEncodedArray(encodedValues);
    }

    public static String encodeStringArrayValue(Object value, boolean escapeJavaNonUTFChars) {
        if (value == null) {
            return null;
        }
        ArrayList<Object> encodedValues = new ArrayList<Object>();
        if (value instanceof List) {
            for (Object item : (List)value) {
                String encodedItem;
                if (item == null || (encodedItem = DriverUtils.encodeStringValue(item, escapeJavaNonUTFChars)) == null) continue;
                encodedValues.add(encodedItem);
            }
        } else {
            String encodedItem = DriverUtils.encodeStringValue(value.toString(), escapeJavaNonUTFChars);
            if (encodedItem != null) {
                encodedValues.add(encodedItem);
            }
        }
        return DriverUtils.toEncodedArray(encodedValues);
    }

    public static String encodeStringValue(Object value, boolean escapeJavaNonUTFChars) {
        if (value == null) {
            return null;
        }
        StringBuilder encodedValue = new StringBuilder();
        String escapedValue = escapeJavaNonUTFChars ? StringEscapeUtils.escapeJavaNonUTFChars(value.toString()) : value.toString();
        encodedValue.append("\"");
        encodedValue.append(escapedValue);
        encodedValue.append("\"");
        return encodedValue.toString();
    }

    public static String[] encodeStringArrayValueToArray(Object value) {
        if (value == null) {
            return null;
        }
        ArrayList<String> notNulls = new ArrayList<String>();
        if (value instanceof List) {
            for (Object currentValue : (List)value) {
                if (currentValue == null) continue;
                notNulls.add(currentValue.toString());
            }
        } else {
            notNulls.add(value.toString());
        }
        return notNulls.size() > 0 ? notNulls.toArray(new String[notNulls.size()]) : new String[]{};
    }

    public static String encodeEnumValue(AnnotationValuePairDefinition valuePairDefinition, Object value) {
        if (value == null) {
            return null;
        }
        StringBuilder encodedValue = new StringBuilder();
        encodedValue.append(NamingUtils.normalizeClassName(valuePairDefinition.getClassName()));
        encodedValue.append(".");
        encodedValue.append(value.toString());
        return encodedValue.toString();
    }

    public static String encodeEnumArrayValue(AnnotationValuePairDefinition valuePairDefinition, Object value) {
        if (value == null) {
            return null;
        }
        ArrayList<Object> encodedValues = new ArrayList<Object>();
        if (value instanceof List) {
            for (Object item : (List)value) {
                String encodedItem;
                if (item == null || (encodedItem = DriverUtils.encodeEnumValue(valuePairDefinition, item)) == null) continue;
                encodedValues.add(encodedItem);
            }
        } else {
            String encodedItem = DriverUtils.encodeEnumValue(valuePairDefinition, value);
            if (encodedItem != null) {
                encodedValues.add(encodedItem);
            }
        }
        return DriverUtils.toEncodedArray(encodedValues);
    }

    public static boolean isEmptyArray(String value) {
        if (value == null || (value = value.trim()).equals("") || !value.startsWith("{") || !value.endsWith("}")) {
            return false;
        }
        return "".equals((value = PortableStringUtils.removeLastChar(PortableStringUtils.removeFirstChar(value, '{'), '}')) != null ? value.trim() : null);
    }

    private static String toEncodedArray(List<Object> values) {
        StringBuilder encodedValue = new StringBuilder();
        boolean hasItems = false;
        encodedValue.append("{");
        for (Object value : values) {
            if (hasItems) {
                encodedValue.append(", ");
            }
            encodedValue.append(value != null ? value.toString() : "null");
            hasItems = true;
        }
        encodedValue.append("}");
        return encodedValue.toString();
    }
}

