/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobDag;
import org.apache.helix.task.ScheduleConfig;
import org.apache.helix.task.TargetState;
import org.apache.helix.task.TaskConfig;
import org.apache.helix.task.TaskUtil;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.beans.JobBean;
import org.apache.helix.task.beans.TaskBean;
import org.apache.helix.task.beans.WorkflowBean;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class Workflow {
    public static final String UNSPECIFIED = "UNSPECIFIED";
    private String _name;
    private WorkflowConfig _workflowConfig;
    private Map<String, Map<String, String>> _jobConfigs;
    private Map<String, List<TaskConfig>> _taskConfigs;

    private Workflow(String name, WorkflowConfig workflowConfig, Map<String, Map<String, String>> jobConfigs, Map<String, List<TaskConfig>> taskConfigs) {
        this._name = name;
        this._workflowConfig = workflowConfig;
        this._jobConfigs = jobConfigs;
        this._taskConfigs = taskConfigs;
        this.validate();
    }

    public String getName() {
        return this._name;
    }

    public Map<String, Map<String, String>> getJobConfigs() {
        return this._jobConfigs;
    }

    public Map<String, List<TaskConfig>> getTaskConfigs() {
        return this._taskConfigs;
    }

    public WorkflowConfig getWorkflowConfig() {
        return this._workflowConfig;
    }

    public static Workflow parse(File file) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(file));
        return Workflow.parse(br);
    }

    public static Workflow parse(String yaml) throws Exception {
        return Workflow.parse(new StringReader(yaml));
    }

    private static Workflow parse(Reader reader) throws Exception {
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(WorkflowBean.class));
        WorkflowBean wf = (WorkflowBean)yaml.load(reader);
        Builder builder = new Builder(wf.name);
        if (wf != null && wf.jobs != null) {
            for (JobBean job : wf.jobs) {
                if (job.name == null) {
                    throw new IllegalArgumentException("A job must have a name.");
                }
                if (job.parents != null) {
                    for (String parent : job.parents) {
                        builder.addParentChildDependency(parent, job.name);
                    }
                }
                builder.addConfig(job.name, "WorkflowID", wf.name);
                builder.addConfig(job.name, "Command", job.command);
                if (job.jobConfigMap != null) {
                    builder.addJobCommandConfigMap(job.name, job.jobConfigMap);
                }
                builder.addConfig(job.name, "TargetResource", job.targetResource);
                if (job.targetPartitionStates != null) {
                    builder.addConfig(job.name, "TargetPartitionStates", Joiner.on((String)",").join(job.targetPartitionStates));
                }
                if (job.targetPartitions != null) {
                    builder.addConfig(job.name, "TargetPartitions", Joiner.on((String)",").join(job.targetPartitions));
                }
                builder.addConfig(job.name, "MaxAttemptsPerTask", String.valueOf(job.maxAttemptsPerTask));
                builder.addConfig(job.name, "MaxForcedReassignmentsPerTask", String.valueOf(job.maxForcedReassignmentsPerTask));
                builder.addConfig(job.name, "ConcurrentTasksPerInstance", String.valueOf(job.numConcurrentTasksPerInstance));
                builder.addConfig(job.name, "TimeoutPerPartition", String.valueOf(job.timeoutPerPartition));
                builder.addConfig(job.name, "FailureThreshold", String.valueOf(job.failureThreshold));
                if (job.tasks == null) continue;
                ArrayList taskConfigs = Lists.newArrayList();
                for (TaskBean task : job.tasks) {
                    taskConfigs.add(TaskConfig.from(task));
                }
                builder.addTaskConfigs(job.name, taskConfigs);
            }
        }
        if (wf.schedule != null) {
            builder.setScheduleConfig(ScheduleConfig.from(wf.schedule));
        }
        builder.setExpiry(wf.expiry);
        return builder.build();
    }

    public void validate() {
        if (!this._jobConfigs.keySet().containsAll(this._workflowConfig.getJobDag().getAllNodes())) {
            throw new IllegalArgumentException("Nodes specified in DAG missing from config");
        }
        if (!this._workflowConfig.getJobDag().getAllNodes().containsAll(this._jobConfigs.keySet())) {
            throw new IllegalArgumentException("Given DAG lacks nodes with supplied configs");
        }
        this._workflowConfig.getJobDag().validate();
        for (String node : this._jobConfigs.keySet()) {
            this.buildConfig(node);
        }
    }

    private JobConfig buildConfig(String job) {
        JobConfig.Builder b = JobConfig.Builder.fromMap(this._jobConfigs.get(job));
        if (this._taskConfigs != null && this._taskConfigs.containsKey(job)) {
            b.addTaskConfigs(this._taskConfigs.get(job));
        }
        return b.build();
    }

    public static class Builder {
        private String _name;
        private JobDag _dag;
        private Map<String, Map<String, String>> _jobConfigs;
        private Map<String, List<TaskConfig>> _taskConfigs;
        private ScheduleConfig _scheduleConfig;
        private long _expiry;

        public Builder(String name) {
            this._name = name;
            this._dag = new JobDag();
            this._jobConfigs = new TreeMap<String, Map<String, String>>();
            this._taskConfigs = new TreeMap<String, List<TaskConfig>>();
            this._expiry = 86400000L;
        }

        public Builder addConfig(String job, String key, String val) {
            job = this.namespacify(job);
            this._dag.addNode(job);
            if (!this._jobConfigs.containsKey(job)) {
                this._jobConfigs.put(job, new TreeMap());
            }
            this._jobConfigs.get(job).put(key, val);
            return this;
        }

        public Builder addJobCommandConfigMap(String job, Map<String, String> jobConfigMap) {
            return this.addConfig(job, "JobCommandConfig", TaskUtil.serializeJobCommandConfigMap(jobConfigMap));
        }

        public Builder addJobConfig(String job, JobConfig.Builder jobConfigBuilder) {
            JobConfig jobConfig = jobConfigBuilder.setWorkflow(this._name).build();
            for (Map.Entry<String, String> e : jobConfig.getResourceConfigMap().entrySet()) {
                String key = e.getKey();
                String val = e.getValue();
                this.addConfig(job, key, val);
            }
            this.addTaskConfigs(job, jobConfig.getTaskConfigMap().values());
            return this;
        }

        public Builder addTaskConfigs(String job, Collection<TaskConfig> taskConfigs) {
            job = this.namespacify(job);
            this._dag.addNode(job);
            if (!this._taskConfigs.containsKey(job)) {
                this._taskConfigs.put(job, new ArrayList());
            }
            if (!this._jobConfigs.containsKey(job)) {
                this._jobConfigs.put(job, new TreeMap());
            }
            this._taskConfigs.get(job).addAll(taskConfigs);
            return this;
        }

        public Builder addParentChildDependency(String parent, String child) {
            parent = this.namespacify(parent);
            child = this.namespacify(child);
            this._dag.addParentToChild(parent, child);
            return this;
        }

        public Builder setScheduleConfig(ScheduleConfig scheduleConfig) {
            this._scheduleConfig = scheduleConfig;
            return this;
        }

        public Builder setExpiry(long expiry) {
            this._expiry = expiry;
            return this;
        }

        public String namespacify(String job) {
            return TaskUtil.getNamespacedJobName(this._name, job);
        }

        public Workflow build() {
            for (String task : this._jobConfigs.keySet()) {
                this._jobConfigs.get(task).put("WorkflowID", this._name);
            }
            WorkflowConfig.Builder builder = new WorkflowConfig.Builder();
            builder.setJobDag(this._dag);
            builder.setTargetState(TargetState.START);
            if (this._scheduleConfig != null) {
                builder.setScheduleConfig(this._scheduleConfig);
            }
            if (this._expiry > 0L) {
                builder.setExpiry(this._expiry);
            }
            return new Workflow(this._name, builder.build(), this._jobConfigs, this._taskConfigs);
        }
    }
}

