/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.cache.LRUCache;
import org.guvnor.common.services.project.builder.events.InvalidateDMOProjectCacheEvent;
import org.guvnor.common.services.project.builder.service.BuildValidationHelper;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Project;
import org.kie.workbench.common.services.backend.builder.Builder;
import org.kie.workbench.common.services.backend.builder.JavaSourceFilter;
import org.kie.workbench.common.services.backend.builder.LRUPomModelCache;
import org.kie.workbench.common.services.backend.builder.LRUProjectDependenciesClassLoaderCache;
import org.kie.workbench.common.services.backend.builder.NoBuilderFoundException;
import org.kie.workbench.common.services.backend.whitelist.PackageNameWhiteListServiceImpl;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.kie.workbench.common.services.shared.project.ProjectImportsService;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.io.IOService;

@ApplicationScoped
public class LRUBuilderCache
extends LRUCache<Project, Builder> {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private KieProjectService projectService;
    @Inject
    private ProjectImportsService importsService;
    @Inject
    @Any
    private Instance<BuildValidationHelper> buildValidationHelperBeans;
    @Inject
    @Named(value="LRUProjectDependenciesClassLoaderCache")
    private LRUProjectDependenciesClassLoaderCache dependenciesClassLoaderCache;
    @Inject
    @Named(value="LRUPomModelCache")
    private LRUPomModelCache pomModelCache;
    @Inject
    private PackageNameWhiteListServiceImpl packageNameWhiteListService;
    @Inject
    @JavaSourceFilter
    private Instance<Predicate<String>> classFilterBeans;
    private final List<BuildValidationHelper> buildValidationHelpers = new ArrayList<BuildValidationHelper>();
    private final List<Predicate<String>> classFilters = new ArrayList<Predicate<String>>();

    @PostConstruct
    public void loadInstances() {
        StreamSupport.stream(this.buildValidationHelperBeans.spliterator(), false).collect(Collectors.toCollection(() -> this.buildValidationHelpers));
        StreamSupport.stream(this.classFilterBeans.spliterator(), false).collect(Collectors.toCollection(() -> this.classFilters));
    }

    @PreDestroy
    public void destroyInstances() {
        this.buildValidationHelpers.forEach(helper -> this.buildValidationHelperBeans.destroy(helper));
        this.classFilters.forEach(filter -> this.classFilterBeans.destroy(filter));
    }

    public synchronized void invalidateProjectCache(@Observes InvalidateDMOProjectCacheEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        Project project = event.getProject();
        if (project != null) {
            this.invalidateCache(project);
        }
    }

    public synchronized Builder assertBuilder(POM pom) throws NoBuilderFoundException {
        for (Project project : this.getKeys()) {
            if (!project.getPom().getGav().equals((Object)pom.getGav())) continue;
            return this.makeBuilder(project);
        }
        throw new NoBuilderFoundException();
    }

    public synchronized Builder assertBuilder(Project project) {
        return this.makeBuilder(project);
    }

    private Builder makeBuilder(Project project) {
        Builder builder = (Builder)this.getEntry(project);
        if (builder == null) {
            builder = new Builder(project, this.ioService, this.projectService, this.importsService, this.buildValidationHelpers, this.dependenciesClassLoaderCache, this.pomModelCache, this.packageNameWhiteListService, this.createSingleClassFilterPredicate());
            this.setEntry(project, builder);
        }
        return builder;
    }

    private Predicate<String> createSingleClassFilterPredicate() {
        return this.classFilters.stream().reduce(o -> true, (p1, p2) -> p1.and(p2));
    }
}

