/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.builder;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.models.datamodel.oracle.TypeSource;
import org.guvnor.common.services.project.builder.model.BuildMessage;
import org.kie.scanner.KieModuleMetaData;
import org.kie.workbench.common.services.backend.builder.BuildMessageBuilder;
import org.kie.workbench.common.services.backend.builder.TypeSourceResolver;
import org.kie.workbench.common.services.shared.whitelist.WhiteList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassVerifier {
    private static final Logger logger = LoggerFactory.getLogger(ClassVerifier.class);
    private static final String ERROR_EXTERNAL_CLASS_VERIFICATION = "Verification of class {0} failed and will not be available for authoring.\nUnderlying system error is: {1}. Please check the necessary external dependencies for this project are configured correctly.";
    private final TypeSourceResolver typeSourceResolver;
    private final KieModuleMetaData kieModuleMetaData;
    private final List<BuildMessage> buildMessages = new ArrayList<BuildMessage>();

    public ClassVerifier(KieModuleMetaData kieModuleMetaData, TypeSourceResolver typeSourceResolver) {
        this.kieModuleMetaData = kieModuleMetaData;
        this.typeSourceResolver = typeSourceResolver;
    }

    public List<BuildMessage> verify(WhiteList whiteList) {
        for (String packageName : this.kieModuleMetaData.getPackages()) {
            if (!whiteList.contains((Object)packageName)) continue;
            for (String className : this.kieModuleMetaData.getClasses(packageName)) {
                this.verifyClass(packageName, className);
            }
        }
        return this.buildMessages;
    }

    private void verifyClass(String packageName, String className) {
        try {
            Class clazz = this.kieModuleMetaData.getClass(packageName, className);
            if (clazz != null) {
                if (TypeSource.JAVA_DEPENDENCY == this.typeSourceResolver.getTypeSource(clazz)) {
                    this.verifyExternalClass(clazz);
                }
            } else {
                logger.warn(MessageFormat.format(ERROR_EXTERNAL_CLASS_VERIFICATION, this.toFQCN(packageName, className)));
            }
        }
        catch (Throwable e) {
            String msg = MessageFormat.format(ERROR_EXTERNAL_CLASS_VERIFICATION, this.toFQCN(packageName, className), e.getMessage());
            logger.warn(msg);
            logger.debug("This state is usually encountered when the Project references a class not on the classpath; e.g. in a Maven 'provided' scope or 'optional' dependency.", e);
            this.buildMessages.add(BuildMessageBuilder.makeWarningMessage(msg));
        }
    }

    private String toFQCN(String packageName, String className) {
        return packageName + "." + className;
    }

    private void verifyExternalClass(Class clazz) {
        clazz.getDeclaredConstructors();
        clazz.getDeclaredFields();
        clazz.getDeclaredMethods();
        clazz.getDeclaredClasses();
        clazz.getDeclaredAnnotations();
    }
}

