/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder.dialect.mvel;

import java.util.Arrays;
import java.util.Map;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.dialect.DialectUtil;
import org.drools.compiler.rule.builder.dialect.mvel.MVELAnalysisResult;
import org.drools.compiler.rule.builder.dialect.mvel.MVELDialect;
import org.drools.core.base.mvel.MVELCompilationUnit;
import org.drools.core.base.mvel.MVELCompileable;
import org.drools.core.base.mvel.MVELObjectExpression;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.spi.DeclarationScopeResolver;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.Wireable;

public class MVELObjectExpressionBuilder {
    private MVELObjectExpressionBuilder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MVELObjectExpression build(String expression, RuleBuildContext context) {
        boolean typesafe = context.isTypesafe();
        context.getDeclarationResolver().pushOnBuildStack((RuleConditionElement)context.getRule().getLhs());
        try {
            MVELDialect dialect = (MVELDialect)context.getDialect("mvel");
            Map decls = context.getDeclarationResolver().getDeclarations(context.getRule());
            MVELAnalysisResult analysis = (MVELAnalysisResult)dialect.analyzeExpression(context, context.getRuleDescr(), expression, new BoundIdentifiers(DeclarationScopeResolver.getDeclarationClasses((Map)decls), context.getKnowledgeBuilder().getGlobals()));
            context.setTypesafe(analysis.isTypesafe());
            BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
            int i = usedIdentifiers.getDeclrClasses().keySet().size();
            Declaration[] previousDeclarations = new Declaration[i];
            i = 0;
            for (String id : usedIdentifiers.getDeclrClasses().keySet()) {
                previousDeclarations[i++] = (Declaration)decls.get(id);
            }
            Arrays.sort(previousDeclarations, RuleTerminalNode.SortDeclarations.instance);
            MVELCompilationUnit unit = dialect.getMVELCompilationUnit(expression, analysis, previousDeclarations, null, null, context, "drools", KnowledgeHelper.class, false, MVELCompilationUnit.Scope.EXPRESSION);
            MVELObjectExpression expr = new MVELObjectExpression(unit, dialect.getId());
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel");
            data.addCompileable((Wireable)context.getRule(), (MVELCompileable)expr);
            expr.compile(data);
            MVELObjectExpression mVELObjectExpression = expr;
            return mVELObjectExpression;
        }
        catch (Exception e) {
            DialectUtil.copyErrorLocation(e, context.getRuleDescr());
            context.addError(new DescrBuildError(context.getParentDescr(), context.getRuleDescr(), null, "Unable to build expression : " + e.getMessage() + "'" + expression + "'"));
            MVELObjectExpression mVELObjectExpression = null;
            return mVELObjectExpression;
        }
        finally {
            context.setTypesafe(typesafe);
        }
    }
}

