/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.payloads;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.payloads.PayloadSpanCollector;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.search.spans.FilterSpans;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanScorer;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.ToStringUtils;

public class SpanPayloadCheckQuery
extends SpanQuery {
    protected final Collection<byte[]> payloadToMatch;
    protected final SpanQuery match;

    public SpanPayloadCheckQuery(SpanQuery match, Collection<byte[]> payloadToMatch) {
        this.match = match;
        this.payloadToMatch = payloadToMatch;
    }

    @Override
    public String getField() {
        return this.match.getField();
    }

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        SpanWeight matchWeight = this.match.createWeight(searcher, false);
        return new SpanPayloadCheckWeight(searcher, needsScores ? SpanPayloadCheckQuery.getTermContexts(matchWeight) : null, matchWeight);
    }

    protected FilterSpans.AcceptStatus checkPayloads(Collection<byte[]> candidate) {
        if (candidate.size() == this.payloadToMatch.size()) {
            Iterator<byte[]> toMatchIter = this.payloadToMatch.iterator();
            for (byte[] candBytes : candidate) {
                if (Arrays.equals(candBytes, toMatchIter.next())) continue;
                return FilterSpans.AcceptStatus.NO;
            }
            return FilterSpans.AcceptStatus.YES;
        }
        return FilterSpans.AcceptStatus.NO;
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("spanPayCheck(");
        buffer.append(this.match.toString(field));
        buffer.append(", payloadRef: ");
        for (byte[] bytes : this.payloadToMatch) {
            ToStringUtils.byteArray(buffer, bytes);
            buffer.append(';');
        }
        buffer.append(")");
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public SpanPayloadCheckQuery clone() {
        SpanPayloadCheckQuery result = new SpanPayloadCheckQuery((SpanQuery)this.match.clone(), this.payloadToMatch);
        result.setBoost(this.getBoost());
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        SpanPayloadCheckQuery other = (SpanPayloadCheckQuery)o;
        return this.payloadToMatch.equals(other.payloadToMatch);
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        h = h * 63 ^ this.payloadToMatch.hashCode();
        return h;
    }

    public class SpanPayloadCheckWeight
    extends SpanWeight {
        final SpanWeight matchWeight;

        public SpanPayloadCheckWeight(IndexSearcher searcher, Map<Term, TermContext> termContexts, SpanWeight matchWeight) throws IOException {
            super(SpanPayloadCheckQuery.this, searcher, termContexts);
            this.matchWeight = matchWeight;
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            this.matchWeight.extractTerms(terms);
        }

        @Override
        public void extractTermContexts(Map<Term, TermContext> contexts) {
            this.matchWeight.extractTermContexts(contexts);
        }

        @Override
        public Spans getSpans(LeafReaderContext context, SpanWeight.Postings requiredPostings) throws IOException {
            final PayloadSpanCollector collector = new PayloadSpanCollector();
            Spans matchSpans = this.matchWeight.getSpans(context, requiredPostings.atLeast(SpanWeight.Postings.PAYLOADS));
            return matchSpans == null ? null : new FilterSpans(matchSpans){

                @Override
                protected FilterSpans.AcceptStatus accept(Spans candidate) throws IOException {
                    collector.reset();
                    candidate.collect(collector);
                    return SpanPayloadCheckQuery.this.checkPayloads(collector.getPayloads());
                }
            };
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            if (this.field == null) {
                return null;
            }
            Terms terms = context.reader().terms(this.field);
            if (terms != null && !terms.hasPositions()) {
                throw new IllegalStateException("field \"" + this.field + "\" was indexed without position data; cannot run SpanQuery (query=" + this.parentQuery + ")");
            }
            Spans spans = this.getSpans(context, SpanWeight.Postings.PAYLOADS);
            Similarity.SimScorer simScorer = this.simWeight == null ? null : this.similarity.simScorer(this.simWeight, context);
            return spans == null ? null : new SpanScorer(spans, this, simScorer);
        }
    }
}

