/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.drools.core.base.accumulators.AbstractAccumulateFunction;

public class LongSumAccumulateFunction
extends AbstractAccumulateFunction {
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public Serializable createContext() {
        return new SumData();
    }

    public void init(Serializable context) {
        ((SumData)context).total = 0L;
    }

    public void accumulate(Serializable context, Object value) {
        if (value != null) {
            ((SumData)context).total += ((Long)value).longValue();
        }
    }

    public void reverse(Serializable context, Object value) {
        if (value != null) {
            ((SumData)context).total -= ((Long)value).longValue();
        }
    }

    public Object getResult(Serializable context) {
        return ((SumData)context).total;
    }

    public boolean supportsReverse() {
        return true;
    }

    public Class<?> getResultType() {
        return Long.class;
    }

    protected static class SumData
    implements Externalizable {
        public long total = 0L;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.total = in.readLong();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.total);
        }
    }
}

