/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper;

import java.util.Map;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.MultiPropertyMapper;
import org.hibernate.envers.internal.entities.mapper.PropertyMapper;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.MapProxyTool;
import org.hibernate.envers.internal.tools.StringTools;

public class MultiDynamicComponentMapper
extends MultiPropertyMapper {
    private PropertyData dynamicComponentData;

    public MultiDynamicComponentMapper(PropertyData dynamicComponentData) {
        this.dynamicComponentData = dynamicComponentData;
    }

    @Override
    public boolean mapToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        boolean ret = false;
        for (PropertyData propertyData : this.properties.keySet()) {
            if (newObj == null && oldObj == null) {
                return false;
            }
            Object newValue = newObj == null ? null : this.getValue(newObj, propertyData);
            Object oldValue = oldObj == null ? null : this.getValue(oldObj, propertyData);
            ret |= ((PropertyMapper)this.properties.get(propertyData)).mapToMapFromEntity(session, data, newValue, oldValue);
        }
        return ret;
    }

    private Object getValue(Object newObj, PropertyData propertyData) {
        return ((Map)newObj).get(propertyData.getBeanName());
    }

    @Override
    public boolean map(SessionImplementor session, Map<String, Object> data, String[] propertyNames, Object[] newState, Object[] oldState) {
        boolean ret = false;
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            Map<String, PropertyData> propertyDatas = this.getPropertyDatas();
            if (!propertyDatas.containsKey(propertyName)) continue;
            PropertyMapper propertyMapper = (PropertyMapper)this.properties.get(propertyDatas.get(propertyName));
            Object newObj = this.getAtIndexOrNull(newState, i);
            Object oldObj = this.getAtIndexOrNull(oldState, i);
            ret |= propertyMapper.mapToMapFromEntity(session, data, newObj, oldObj);
            propertyMapper.mapModifiedFlagsToMapFromEntity(session, data, newObj, oldObj);
        }
        return ret;
    }

    @Override
    public void mapModifiedFlagsToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        for (PropertyData propertyData : this.properties.keySet()) {
            if (newObj == null && oldObj == null) {
                return;
            }
            Object newValue = newObj == null ? null : this.getValue(newObj, propertyData);
            Object oldValue = oldObj == null ? null : this.getValue(oldObj, propertyData);
            ((PropertyMapper)this.properties.get(propertyData)).mapModifiedFlagsToMapFromEntity(session, data, newValue, oldValue);
        }
    }

    @Override
    public void mapToEntityFromMap(EnversService enversService, Object obj, Map data, Object primaryKey, AuditReaderImplementor versionsReader, Number revision) {
        Object mapProxy = MapProxyTool.newInstanceOfBeanProxyForMap(this.generateClassName(data, this.dynamicComponentData.getBeanName()), (Map)obj, this.properties.keySet(), enversService.getClassLoaderService());
        for (PropertyData propertyData : this.properties.keySet()) {
            PropertyMapper mapper = (PropertyMapper)this.properties.get(propertyData);
            mapper.mapToEntityFromMap(enversService, mapProxy, data, primaryKey, versionsReader, revision);
        }
    }

    private String generateClassName(Map data, String dynamicComponentPropertyName) {
        return (data.get("$type$") + StringTools.capitalizeFirst(dynamicComponentPropertyName)).replaceAll("_", "");
    }
}

