/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix;

import java.util.Arrays;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyPathConfig;
import org.apache.helix.PropertyType;
import org.apache.helix.model.ClusterConstraints;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.Error;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.HealthStat;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LeaderHistory;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.model.PauseSignal;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.model.StatusUpdate;
import org.apache.log4j.Logger;

public class PropertyKey {
    private static Logger LOG = Logger.getLogger(PropertyKey.class);
    public PropertyType _type;
    private final String[] _params;
    Class<? extends HelixProperty> _typeClazz;
    HelixConfigScope.ConfigScopeProperty _configScope;

    public PropertyKey(PropertyType type, Class<? extends HelixProperty> typeClazz, String ... params) {
        this(type, null, typeClazz, params);
    }

    public PropertyKey(PropertyType type, HelixConfigScope.ConfigScopeProperty configScope, Class<? extends HelixProperty> typeClazz, String ... params) {
        this._type = type;
        if (params == null || params.length == 0 || Arrays.asList(params).contains(null)) {
            throw new IllegalArgumentException("params cannot be null");
        }
        this._params = params;
        this._typeClazz = typeClazz;
        this._configScope = configScope;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.getPath();
    }

    public String getPath() {
        String clusterName = this._params[0];
        String[] subKeys = Arrays.copyOfRange(this._params, 1, this._params.length);
        String path = PropertyPathConfig.getPath(this._type, clusterName, subKeys);
        if (path == null) {
            LOG.error((Object)("Invalid property key with type:" + (Object)((Object)this._type) + "subKeys:" + Arrays.toString(this._params)));
        }
        return path;
    }

    public PropertyType getType() {
        return this._type;
    }

    public String[] getParams() {
        return this._params;
    }

    public Class<? extends HelixProperty> getTypeClass() {
        return this._typeClazz;
    }

    public HelixConfigScope.ConfigScopeProperty getConfigScope() {
        return this._configScope;
    }

    public static class Builder {
        private final String _clusterName;

        public Builder(String clusterName) {
            this._clusterName = clusterName;
        }

        public PropertyKey idealStates() {
            return new PropertyKey(PropertyType.IDEALSTATES, IdealState.class, this._clusterName);
        }

        public PropertyKey idealStates(String resourceName) {
            return new PropertyKey(PropertyType.IDEALSTATES, IdealState.class, this._clusterName, resourceName);
        }

        public PropertyKey stateModelDefs() {
            return new PropertyKey(PropertyType.STATEMODELDEFS, StateModelDefinition.class, this._clusterName);
        }

        public PropertyKey stateModelDef(String stateModelName) {
            return new PropertyKey(PropertyType.STATEMODELDEFS, StateModelDefinition.class, this._clusterName, stateModelName);
        }

        public PropertyKey clusterConfigs() {
            return new PropertyKey(PropertyType.CONFIGS, HelixConfigScope.ConfigScopeProperty.CLUSTER, HelixProperty.class, this._clusterName, HelixConfigScope.ConfigScopeProperty.CLUSTER.toString());
        }

        public PropertyKey clusterConfig() {
            return new PropertyKey(PropertyType.CONFIGS, HelixConfigScope.ConfigScopeProperty.CLUSTER, HelixProperty.class, this._clusterName, HelixConfigScope.ConfigScopeProperty.CLUSTER.toString(), this._clusterName);
        }

        public PropertyKey instanceConfigs() {
            return new PropertyKey(PropertyType.CONFIGS, HelixConfigScope.ConfigScopeProperty.PARTICIPANT, InstanceConfig.class, this._clusterName, HelixConfigScope.ConfigScopeProperty.PARTICIPANT.toString());
        }

        public PropertyKey instanceConfig(String instanceName) {
            return new PropertyKey(PropertyType.CONFIGS, HelixConfigScope.ConfigScopeProperty.PARTICIPANT, InstanceConfig.class, this._clusterName, HelixConfigScope.ConfigScopeProperty.PARTICIPANT.toString(), instanceName);
        }

        public PropertyKey resourceConfigs() {
            return new PropertyKey(PropertyType.CONFIGS, HelixConfigScope.ConfigScopeProperty.RESOURCE, HelixProperty.class, this._clusterName, HelixConfigScope.ConfigScopeProperty.RESOURCE.toString());
        }

        public PropertyKey resourceConfig(String resourceName) {
            return new PropertyKey(PropertyType.CONFIGS, HelixConfigScope.ConfigScopeProperty.RESOURCE, HelixProperty.class, this._clusterName, HelixConfigScope.ConfigScopeProperty.RESOURCE.toString(), resourceName);
        }

        public PropertyKey partitionConfig(String resourceName, String partitionName) {
            return new PropertyKey(PropertyType.CONFIGS, HelixConfigScope.ConfigScopeProperty.RESOURCE, HelixProperty.class, this._clusterName, HelixConfigScope.ConfigScopeProperty.RESOURCE.toString(), resourceName);
        }

        public PropertyKey partitionConfig(String instanceName, String resourceName, String partitionName) {
            return new PropertyKey(PropertyType.CONFIGS, HelixConfigScope.ConfigScopeProperty.RESOURCE, HelixProperty.class, this._clusterName, HelixConfigScope.ConfigScopeProperty.RESOURCE.toString(), resourceName);
        }

        public PropertyKey constraints() {
            return new PropertyKey(PropertyType.CONFIGS, ClusterConstraints.class, this._clusterName, HelixConfigScope.ConfigScopeProperty.CONSTRAINT.toString());
        }

        public PropertyKey constraint(String constraintType) {
            return new PropertyKey(PropertyType.CONFIGS, ClusterConstraints.class, this._clusterName, HelixConfigScope.ConfigScopeProperty.CONSTRAINT.toString(), constraintType);
        }

        public PropertyKey liveInstances() {
            return new PropertyKey(PropertyType.LIVEINSTANCES, LiveInstance.class, this._clusterName);
        }

        public PropertyKey liveInstance(String instanceName) {
            return new PropertyKey(PropertyType.LIVEINSTANCES, LiveInstance.class, this._clusterName, instanceName);
        }

        public PropertyKey instances() {
            return new PropertyKey(PropertyType.INSTANCES, null, this._clusterName);
        }

        public PropertyKey messages(String instanceName) {
            return new PropertyKey(PropertyType.MESSAGES, Message.class, this._clusterName, instanceName);
        }

        public PropertyKey errors(String instanceName) {
            return new PropertyKey(PropertyType.ERRORS, Error.class, this._clusterName, instanceName);
        }

        public PropertyKey message(String instanceName, String messageId) {
            return new PropertyKey(PropertyType.MESSAGES, Message.class, this._clusterName, instanceName, messageId);
        }

        public PropertyKey sessions(String instanceName) {
            return new PropertyKey(PropertyType.CURRENTSTATES, CurrentState.class, this._clusterName, instanceName);
        }

        public PropertyKey currentStates(String instanceName, String sessionId) {
            return new PropertyKey(PropertyType.CURRENTSTATES, CurrentState.class, this._clusterName, instanceName, sessionId);
        }

        public PropertyKey currentState(String instanceName, String sessionId, String resourceName) {
            return new PropertyKey(PropertyType.CURRENTSTATES, CurrentState.class, this._clusterName, instanceName, sessionId, resourceName);
        }

        public PropertyKey currentState(String instanceName, String sessionId, String resourceName, String bucketName) {
            if (bucketName == null) {
                return new PropertyKey(PropertyType.CURRENTSTATES, CurrentState.class, this._clusterName, instanceName, sessionId, resourceName);
            }
            return new PropertyKey(PropertyType.CURRENTSTATES, CurrentState.class, this._clusterName, instanceName, sessionId, resourceName, bucketName);
        }

        public PropertyKey stateTransitionStatus(String instanceName, String sessionId, String resourceName, String partitionName) {
            return new PropertyKey(PropertyType.STATUSUPDATES, StatusUpdate.class, this._clusterName, instanceName, sessionId, resourceName, partitionName);
        }

        public PropertyKey stateTransitionStatus(String instanceName, String sessionId, String resourceName) {
            return new PropertyKey(PropertyType.STATUSUPDATES, StatusUpdate.class, this._clusterName, instanceName, sessionId, resourceName);
        }

        public PropertyKey stateTransitionStatus(String instanceName, String sessionId) {
            return new PropertyKey(PropertyType.STATUSUPDATES, StatusUpdate.class, this._clusterName, instanceName, sessionId);
        }

        public PropertyKey stateTransitionStatus(String instanceName) {
            return new PropertyKey(PropertyType.STATUSUPDATES, StatusUpdate.class, this._clusterName, instanceName);
        }

        public PropertyKey taskStatus(String instanceName, String sessionId, String msgType, String msgId) {
            return new PropertyKey(PropertyType.STATUSUPDATES, StatusUpdate.class, this._clusterName, instanceName, sessionId, msgType, msgId);
        }

        public PropertyKey stateTransitionError(String instanceName, String sessionId, String resourceName, String partitionName) {
            return new PropertyKey(PropertyType.ERRORS, Error.class, this._clusterName, instanceName, sessionId, resourceName, partitionName);
        }

        public PropertyKey stateTransitionErrors(String instanceName, String sessionId, String resourceName) {
            return new PropertyKey(PropertyType.ERRORS, Error.class, this._clusterName, instanceName, sessionId, resourceName);
        }

        public PropertyKey stateTransitionErrors(String instanceName) {
            return new PropertyKey(PropertyType.ERRORS, Error.class, this._clusterName, instanceName);
        }

        public PropertyKey taskError(String instanceName, String sessionId, String msgType, String msgId) {
            return new PropertyKey(PropertyType.ERRORS, null, this._clusterName, instanceName, sessionId, msgType, msgId);
        }

        public PropertyKey externalViews() {
            return new PropertyKey(PropertyType.EXTERNALVIEW, ExternalView.class, this._clusterName);
        }

        public PropertyKey externalView(String resourceName) {
            return new PropertyKey(PropertyType.EXTERNALVIEW, ExternalView.class, this._clusterName, resourceName);
        }

        public PropertyKey controller() {
            return new PropertyKey(PropertyType.CONTROLLER, null, this._clusterName);
        }

        public PropertyKey controllerTaskErrors() {
            return new PropertyKey(PropertyType.ERRORS_CONTROLLER, StatusUpdate.class, this._clusterName);
        }

        public PropertyKey controllerTaskError(String errorId) {
            return new PropertyKey(PropertyType.ERRORS_CONTROLLER, Error.class, this._clusterName, errorId);
        }

        public PropertyKey controllerTaskStatuses(String subPath) {
            return new PropertyKey(PropertyType.STATUSUPDATES_CONTROLLER, StatusUpdate.class, this._clusterName, subPath);
        }

        public PropertyKey controllerTaskStatus(String subPath, String recordName) {
            return new PropertyKey(PropertyType.STATUSUPDATES_CONTROLLER, StatusUpdate.class, this._clusterName, subPath, recordName);
        }

        public PropertyKey controllerTaskStatuses() {
            return new PropertyKey(PropertyType.STATUSUPDATES_CONTROLLER, StatusUpdate.class, this._clusterName);
        }

        public PropertyKey controllerMessages() {
            return new PropertyKey(PropertyType.MESSAGES_CONTROLLER, Message.class, this._clusterName);
        }

        public PropertyKey controllerMessage(String msgId) {
            return new PropertyKey(PropertyType.MESSAGES_CONTROLLER, Message.class, this._clusterName, msgId);
        }

        public PropertyKey controllerLeaderHistory() {
            return new PropertyKey(PropertyType.HISTORY, LeaderHistory.class, this._clusterName);
        }

        public PropertyKey controllerLeader() {
            return new PropertyKey(PropertyType.LEADER, LiveInstance.class, this._clusterName);
        }

        public PropertyKey pause() {
            return new PropertyKey(PropertyType.PAUSE, PauseSignal.class, this._clusterName);
        }

        public PropertyKey healthReport(String instanceName, String id) {
            return new PropertyKey(PropertyType.HEALTHREPORT, HealthStat.class, this._clusterName, instanceName, id);
        }

        public PropertyKey healthReports(String instanceName) {
            return new PropertyKey(PropertyType.HEALTHREPORT, HealthStat.class, this._clusterName, instanceName);
        }
    }
}

