/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.TimerTask;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyType;
import org.apache.helix.ZNRecord;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.helix.util.HelixUtil;
import org.apache.log4j.Logger;
import org.apache.zookeeper.data.Stat;

public class ZKPathDataDumpTask
extends TimerTask {
    static Logger LOG = Logger.getLogger(ZKPathDataDumpTask.class);
    private final long _thresholdNoChangeMsForStatusUpdates;
    private final long _thresholdNoChangeMsForErrors;
    private final int _maxLeafCount;
    private final HelixManager _manager;
    private final ZNRecordSerializer _jsonSerializer;

    public ZKPathDataDumpTask(HelixManager manager, long thresholdNoChangeMsForStatusUpdates, long thresholdNoChangeMsForErrors, int maxLeafCount) {
        LOG.info((Object)("Init ZKPathDataDumpTask for cluster: " + manager.getClusterName() + ", thresholdNoChangeMsForStatusUpdates: " + thresholdNoChangeMsForStatusUpdates + ", thresholdNoChangeMsForErrors: " + thresholdNoChangeMsForErrors + ", maxLeafCount: " + maxLeafCount));
        this._manager = manager;
        this._jsonSerializer = new ZNRecordSerializer();
        this._thresholdNoChangeMsForStatusUpdates = thresholdNoChangeMsForStatusUpdates;
        this._thresholdNoChangeMsForErrors = thresholdNoChangeMsForErrors;
        this._maxLeafCount = maxLeafCount;
    }

    @Override
    public void run() {
        LOG.info((Object)("Scan statusUpdates and errors for cluster: " + this._manager.getClusterName() + ", by controller: " + this._manager));
        HelixDataAccessor accessor = this._manager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        BaseDataAccessor<ZNRecord> baseAccessor = accessor.getBaseDataAccessor();
        List<String> instances = accessor.getChildNames(keyBuilder.instanceConfigs());
        for (String instance : instances) {
            String statusUpdatePath = HelixUtil.getInstancePropertyPath(this._manager.getClusterName(), instance, PropertyType.STATUSUPDATES);
            this.dump(baseAccessor, statusUpdatePath, this._thresholdNoChangeMsForStatusUpdates, this._maxLeafCount);
            String errorPath = HelixUtil.getInstancePropertyPath(this._manager.getClusterName(), instance, PropertyType.ERRORS);
            this.dump(baseAccessor, errorPath, this._thresholdNoChangeMsForErrors, this._maxLeafCount);
        }
        String controllerStatusUpdatePath = HelixUtil.getControllerPropertyPath(this._manager.getClusterName(), PropertyType.STATUSUPDATES_CONTROLLER);
        this.dump(baseAccessor, controllerStatusUpdatePath, this._thresholdNoChangeMsForStatusUpdates, this._maxLeafCount);
        String controllerErrorPath = HelixUtil.getControllerPropertyPath(this._manager.getClusterName(), PropertyType.ERRORS_CONTROLLER);
        this.dump(baseAccessor, controllerErrorPath, this._thresholdNoChangeMsForErrors, this._maxLeafCount);
    }

    static List<String> scanPath(BaseDataAccessor<ZNRecord> accessor, String ancestorPath) {
        LinkedList queue = Lists.newLinkedList();
        queue.add(ancestorPath);
        ArrayList leafPaths = Lists.newArrayList();
        while (!queue.isEmpty()) {
            String path = (String)queue.remove(0);
            List<String> childNames = accessor.getChildNames(path, 0);
            if (childNames == null) continue;
            if (childNames.isEmpty() && !path.equals(ancestorPath)) {
                leafPaths.add(path);
            }
            for (String childName : childNames) {
                String subPath = String.format("%s/%s", path, childName);
                queue.add(subPath);
            }
        }
        return leafPaths;
    }

    void dump(BaseDataAccessor<ZNRecord> accessor, String ancestorPath, long threshold, int maxLeafCount) {
        List<String> leafPaths = ZKPathDataDumpTask.scanPath(accessor, ancestorPath);
        if (leafPaths.isEmpty()) {
            return;
        }
        Stat[] stats = accessor.getStats(leafPaths, 0);
        ArrayList dumpPaths = Lists.newArrayList();
        long now = System.currentTimeMillis();
        for (int i = 0; i < stats.length; ++i) {
            Stat stat = stats[i];
            if (stats.length <= maxLeafCount && now - stat.getMtime() <= threshold) continue;
            dumpPaths.add(leafPaths.get(i));
        }
        LOG.info((Object)("Dump statusUpdates and errors records for pahts: " + dumpPaths));
        List<ZNRecord> dumpRecords = accessor.get(dumpPaths, null, 0);
        for (ZNRecord record : dumpRecords) {
            if (record == null) continue;
            LOG.info((Object)new String(this._jsonSerializer.serialize(record)));
        }
        accessor.remove(dumpPaths, 0);
    }
}

