/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.pipeline.execution.impl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import org.guvnor.ala.pipeline.execution.PipelineExecutorException;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTask;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTaskDef;
import org.guvnor.ala.pipeline.execution.RegistrableOutput;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class PipelineExecutorTaskImpl
implements PipelineExecutorTask,
Cloneable {
    private PipelineExecutorTaskDef taskDef;
    private String executionId;
    private PipelineExecutorTask.Status pipelineStatus = PipelineExecutorTask.Status.SCHEDULED;
    @JsonInclude
    private Map<String, PipelineExecutorTask.Status> stageStatus = new HashMap<String, PipelineExecutorTask.Status>();
    @JsonInclude
    private Map<String, PipelineExecutorException> stageError = new HashMap<String, PipelineExecutorException>();
    private PipelineExecutorException pipelineError;
    private RegistrableOutput output;

    public PipelineExecutorTaskImpl() {
    }

    public PipelineExecutorTaskImpl(PipelineExecutorTaskDef taskDef, String executionId) {
        this.taskDef = taskDef;
        this.setId(executionId);
        taskDef.getStages().forEach(stage -> this.setStageStatus((String)stage, PipelineExecutorTask.Status.SCHEDULED));
    }

    @Override
    public PipelineExecutorTaskDef getTaskDef() {
        return this.taskDef;
    }

    @Override
    public String getId() {
        return this.executionId;
    }

    private void setId(String executionId) {
        this.executionId = executionId;
        this.getTaskDef().getInput().put("_pipelineExecutionId_", executionId);
    }

    @Override
    public PipelineExecutorTask.Status getPipelineStatus() {
        return this.pipelineStatus;
    }

    public void setPipelineStatus(PipelineExecutorTask.Status pipelineStatus) {
        this.pipelineStatus = pipelineStatus;
    }

    public void setStageStatus(String stage, PipelineExecutorTask.Status status) {
        this.stageStatus.put(stage, status);
    }

    @Override
    public PipelineExecutorTask.Status getStageStatus(String stage) {
        return this.stageStatus.get(stage);
    }

    public void setStageError(String stage, PipelineExecutorException error) {
        this.stageError.put(stage, error);
    }

    @Override
    public PipelineExecutorException getStageError(String stage) {
        return this.stageError.get(stage);
    }

    public void setPipelineError(PipelineExecutorException error) {
        this.pipelineError = error;
    }

    @Override
    public PipelineExecutorException getPipelineError() {
        return this.pipelineError;
    }

    @Override
    public RegistrableOutput getOutput() {
        return this.output;
    }

    public void setOutput(RegistrableOutput output) {
        this.output = output;
    }

    public void clearErrors() {
        this.stageError.clear();
        this.pipelineError = null;
    }

    protected Object clone() throws CloneNotSupportedException {
        PipelineExecutorTaskImpl clone = new PipelineExecutorTaskImpl(this.taskDef, this.executionId);
        clone.setPipelineStatus(this.getPipelineStatus());
        this.stageStatus.forEach(clone::setStageStatus);
        this.stageError.forEach(clone::setStageError);
        clone.setPipelineError(this.pipelineError);
        clone.setOutput(this.output);
        return clone;
    }
}

