/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.registry.inmemory;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTrace;
import org.guvnor.ala.registry.PipelineExecutorRegistry;
import org.uberfire.commons.validation.PortablePreconditions;

@ApplicationScoped
public class InMemoryPipelineExecutorRegistry
implements PipelineExecutorRegistry {
    protected Map<String, PipelineExecutorTrace> recordsMap = new ConcurrentHashMap<String, PipelineExecutorTrace>();

    @Override
    public void register(PipelineExecutorTrace trace) {
        PortablePreconditions.checkNotNull((String)"trace", (Object)trace);
        this.recordsMap.put(trace.getTaskId(), trace);
    }

    @Override
    public void deregister(String pipelineExecutionId) {
        PortablePreconditions.checkNotNull((String)"pipelineExecutionId", (Object)pipelineExecutionId);
        this.recordsMap.remove(pipelineExecutionId);
    }

    @Override
    public PipelineExecutorTrace getExecutorTrace(String pipelineExecutionId) {
        return this.recordsMap.get(pipelineExecutionId);
    }

    @Override
    public Collection<PipelineExecutorTrace> getExecutorTraces() {
        return this.recordsMap.values();
    }
}

