/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.builder.core;

import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.model.ProjectRepositories;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.common.services.project.service.GAVAlreadyExistsException;
import org.guvnor.common.services.project.service.ProjectRepositoriesService;
import org.guvnor.common.services.project.service.ProjectRepositoryResolver;
import org.kie.workbench.common.services.shared.project.KieProject;

@ApplicationScoped
public class DeploymentVerifier {
    private ProjectRepositoryResolver repositoryResolver;
    private ProjectRepositoriesService projectRepositoriesService;

    public DeploymentVerifier() {
    }

    @Inject
    public DeploymentVerifier(ProjectRepositoryResolver repositoryResolver, ProjectRepositoriesService projectRepositoriesService) {
        this.repositoryResolver = repositoryResolver;
        this.projectRepositoriesService = projectRepositoriesService;
    }

    public void verifyWithException(Project project, DeploymentMode deploymentMode) {
        if (DeploymentMode.VALIDATED.equals((Object)deploymentMode)) {
            GAV gav = project.getPom().getGav();
            if (gav.isSnapshot()) {
                return;
            }
            ProjectRepositories projectRepositories = (ProjectRepositories)this.projectRepositoriesService.load(((KieProject)project).getRepositoriesPath());
            Set repositories = this.repositoryResolver.getRepositoriesResolvingArtifact(gav, project, projectRepositories.filterByIncluded());
            if (repositories.size() > 0) {
                throw new GAVAlreadyExistsException(gav, repositories);
            }
        }
    }
}

