/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.kie.workbench.common.services.backend.compiler.Order;
import org.kie.workbench.common.services.backend.compiler.configuration.ConfigurationKey;
import org.kie.workbench.common.services.backend.compiler.configuration.ConfigurationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationPropertiesStrategy
implements ConfigurationStrategy,
Order {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationPropertiesStrategy.class);
    protected Map<ConfigurationKey, String> conf;
    private String propertiesFile = "IncrementalCompiler.properties";
    private Boolean valid = Boolean.FALSE;

    public ConfigurationPropertiesStrategy() {
        Properties props = this.loadProperties();
        if (this.isValid().booleanValue()) {
            this.conf = new HashMap<ConfigurationKey, String>();
            this.conf.put(ConfigurationKey.MAVEN_PLUGINS, props.getProperty(ConfigurationKey.MAVEN_PLUGINS.name()));
            this.conf.put(ConfigurationKey.MAVEN_COMPILER_PLUGIN, props.getProperty(ConfigurationKey.MAVEN_COMPILER_PLUGIN.name()));
            this.conf.put(ConfigurationKey.MAVEN_COMPILER_PLUGIN_VERSION, props.getProperty(ConfigurationKey.MAVEN_COMPILER_PLUGIN_VERSION.name()));
            this.conf.put(ConfigurationKey.ALTERNATIVE_COMPILER_PLUGINS, props.getProperty(ConfigurationKey.ALTERNATIVE_COMPILER_PLUGINS.name()));
            this.conf.put(ConfigurationKey.ALTERNATIVE_COMPILER_PLUGIN, props.getProperty(ConfigurationKey.ALTERNATIVE_COMPILER_PLUGIN.name()));
            this.conf.put(ConfigurationKey.ALTERNATIVE_COMPILER_PLUGIN_VERSION, props.getProperty(ConfigurationKey.ALTERNATIVE_COMPILER_PLUGIN_VERSION.name()));
            this.conf.put(ConfigurationKey.KIE_MAVEN_PLUGINS, props.getProperty(ConfigurationKey.KIE_MAVEN_PLUGINS.name()));
            this.conf.put(ConfigurationKey.KIE_MAVEN_PLUGIN, props.getProperty(ConfigurationKey.KIE_MAVEN_PLUGIN.name()));
        }
    }

    private Properties loadProperties() {
        Properties prop = new Properties();
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(this.propertiesFile);
        if (in == null) {
            logger.info("{} not available with the classloader, skip to the next ConfigurationStrategy. \n", (Object)this.propertiesFile);
            this.valid = Boolean.FALSE;
        } else {
            try {
                prop.load(in);
                in.close();
                this.valid = Boolean.TRUE;
            }
            catch (IOException e) {
                logger.error(e.getMessage());
                this.valid = Boolean.FALSE;
            }
        }
        return prop;
    }

    @Override
    public Map<ConfigurationKey, String> loadConfiguration() {
        return Collections.unmodifiableMap(this.conf);
    }

    @Override
    public Boolean isValid() {
        return this.valid;
    }

    @Override
    public Integer getOrder() {
        return 100;
    }
}

