/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.external339;

import com.google.common.base.Charsets;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.maven.BuildAbort;
import org.apache.maven.InternalErrorException;
import org.apache.maven.Maven;
import org.apache.maven.building.FileSource;
import org.apache.maven.building.Problem;
import org.apache.maven.building.Source;
import org.apache.maven.cli.CLIManager;
import org.apache.maven.cli.event.DefaultEventSpyContext;
import org.apache.maven.cli.event.ExecutionEventLogger;
import org.apache.maven.cli.internal.BootstrapCoreExtensionManager;
import org.apache.maven.cli.internal.extension.model.CoreExtension;
import org.apache.maven.cli.internal.extension.model.io.xpp3.CoreExtensionsXpp3Reader;
import org.apache.maven.cli.logging.Slf4jConfiguration;
import org.apache.maven.cli.logging.Slf4jConfigurationFactory;
import org.apache.maven.cli.logging.Slf4jLoggerManager;
import org.apache.maven.cli.logging.Slf4jStdoutLogger;
import org.apache.maven.cli.transfer.ConsoleMavenTransferListener;
import org.apache.maven.cli.transfer.QuietMavenTransferListener;
import org.apache.maven.cli.transfer.Slf4jMavenTransferListener;
import org.apache.maven.eventspy.EventSpy;
import org.apache.maven.eventspy.internal.EventSpyDispatcher;
import org.apache.maven.exception.DefaultExceptionHandler;
import org.apache.maven.exception.ExceptionSummary;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.extension.internal.CoreExports;
import org.apache.maven.extension.internal.CoreExtensionEntry;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.properties.internal.EnvironmentUtils;
import org.apache.maven.properties.internal.SystemProperties;
import org.apache.maven.toolchain.building.DefaultToolchainsBuildingRequest;
import org.apache.maven.toolchain.building.ToolchainsBuilder;
import org.apache.maven.toolchain.building.ToolchainsBuildingRequest;
import org.apache.maven.toolchain.building.ToolchainsBuildingResult;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.transfer.TransferListener;
import org.kie.workbench.common.services.backend.compiler.configuration.FileSystemImpl;
import org.kie.workbench.common.services.backend.compiler.external339.AFCLIReportingUtils;
import org.kie.workbench.common.services.backend.compiler.external339.AFCliRequest;
import org.kie.workbench.common.services.backend.compiler.external339.AFConfigurationProcessor;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;

public class AFMavenCli {
    public static final String MULTIMODULE_PROJECT_DIRECTORY = "maven.multiModuleProjectDirectory";
    public static final String userHome = System.getProperty("user.home");
    public static final Path userMavenConfigurationHome = Paths.get(userHome, ".m2");
    private static final Logger logger = LoggerFactory.getLogger(AFMavenCli.class);
    private static final String EXT_CLASS_PATH = "maven.ext.class.path";
    private static final String EXTENSIONS_FILENAME = ".mvn/extensions.xml";
    private LoggerManager plexusLoggerManager;
    private ILoggerFactory slf4jLoggerFactory;
    private Logger slf4jLogger;
    private EventSpyDispatcher eventSpyDispatcher;
    private ModelProcessor modelProcessor;
    private Maven maven;
    private MavenExecutionRequestPopulator executionRequestPopulator;
    private ToolchainsBuilder toolchainsBuilder;
    private DefaultSecDispatcher dispatcher;
    private Map<String, AFConfigurationProcessor> configurationProcessors;
    private PrintStream output;
    private FileSystemImpl fs;

    public AFMavenCli(FileSystemImpl fs) {
        this.output = System.out;
        this.fs = fs;
    }

    public AFMavenCli(PrintStream output) {
        this.output = output;
    }

    private static <T> List<T> reverse(List<T> list) {
        ArrayList<T> copy = new ArrayList<T>(list);
        Collections.reverse(copy);
        return copy;
    }

    static File resolveFile(File file, String workingDirectory) {
        if (file == null) {
            return null;
        }
        if (file.isAbsolute()) {
            return file;
        }
        if (file.getPath().startsWith(File.separator)) {
            return file.getAbsoluteFile();
        }
        return new File(workingDirectory, file.getPath()).getAbsoluteFile();
    }

    static Path resolvePath(Path file, String workingDirectory) {
        return file == null ? null : (file.isAbsolute() ? file : (file.getFileName().startsWith(File.separator) ? file.toAbsolutePath() : Paths.get(workingDirectory, file.getFileName().toString())));
    }

    static void populateProperties(CommandLine commandLine, Properties systemProperties, Properties userProperties) {
        String[] defStrs;
        EnvironmentUtils.addEnvVars((Properties)systemProperties);
        if (commandLine.hasOption('D') && (defStrs = commandLine.getOptionValues('D')) != null) {
            for (String defStr : defStrs) {
                AFMavenCli.setCliProperty(defStr, userProperties);
            }
        }
        SystemProperties.addSystemProperties((Properties)systemProperties);
        Properties buildProperties = AFCLIReportingUtils.getBuildProperties();
        String mavenVersion = buildProperties.getProperty("version");
        systemProperties.setProperty("maven.version", mavenVersion);
        String mavenBuildVersion = AFCLIReportingUtils.createMavenVersionString(buildProperties);
        systemProperties.setProperty("maven.build.version", mavenBuildVersion);
    }

    protected static void setCliProperty(String property, Properties properties) {
        String value;
        String name;
        int i = property.indexOf("=");
        if (i <= 0) {
            name = property.trim();
            value = "true";
        } else {
            name = property.substring(0, i).trim();
            value = property.substring(i + 1);
        }
        properties.setProperty(name, value);
        System.setProperty(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doMain(AFCliRequest cliRequest, ClassWorld classWorld) {
        PlexusContainer localContainer = null;
        try {
            this.initialize(cliRequest);
            this.cli(cliRequest);
            this.logging(cliRequest);
            this.version(cliRequest);
            this.properties(cliRequest);
            localContainer = this.container(cliRequest, classWorld);
            this.commands(cliRequest);
            this.configure(cliRequest);
            this.toolchains(cliRequest);
            this.populateRequest(cliRequest);
            this.repository(cliRequest);
            int n = this.execute(cliRequest);
            return n;
        }
        catch (ExitException e) {
            e.getStackTrace();
            int n = e.exitCode;
            return n;
        }
        catch (UnrecognizedOptionException e) {
            e.getStackTrace();
            int n = 1;
            return n;
        }
        catch (BuildAbort e) {
            e.getStackTrace();
            AFCLIReportingUtils.showError(this.slf4jLogger, "ABORTED", e, cliRequest.isShowErrors());
            int n = 2;
            return n;
        }
        catch (Exception e) {
            e.getStackTrace();
            AFCLIReportingUtils.showError(this.slf4jLogger, "Error executing Maven.", e, cliRequest.isShowErrors());
            int n = 1;
            return n;
        }
        finally {
            if (localContainer != null) {
                localContainer.dispose();
                localContainer = null;
            }
        }
    }

    protected void initialize(AFCliRequest cliRequest) throws ExitException {
        if (cliRequest.getWorkingDirectory() == null) {
            cliRequest.setWorkingDirectory(System.getProperty("user.dir"));
        }
        if (cliRequest.getMultiModuleProjectDirectory() == null) {
            String basedirProperty = System.getProperty(MULTIMODULE_PROJECT_DIRECTORY);
            if (basedirProperty == null) {
                System.err.format("-D%s system propery is not set. Check $M2_HOME environment variable and mvn script match.", MULTIMODULE_PROJECT_DIRECTORY);
                throw new ExitException(1);
            }
            Path basedir = basedirProperty != null ? Paths.get(basedirProperty, new String[0]) : Paths.get("", new String[0]);
            cliRequest.setMultiModuleProjectDirectory(basedir.toAbsolutePath().toString());
        }
    }

    protected void cli(AFCliRequest cliRequest) throws Exception {
        this.slf4jLogger = new Slf4jStdoutLogger();
        CLIManager cliManager = new CLIManager();
        ArrayList<String> args = new ArrayList<String>();
        try {
            Path configFile = Paths.get(cliRequest.getMultiModuleProjectDirectory(), ".mvn/maven.config");
            if (Files.isRegularFile(configFile, new LinkOption[0])) {
                for (String arg : com.google.common.io.Files.toString((File)configFile.toFile(), (Charset)Charsets.UTF_8).split("\\s+")) {
                    args.add(arg);
                }
                CommandLine config = cliManager.parse(args.toArray(new String[args.size()]));
                List unrecongized = config.getArgList();
                if (!unrecongized.isEmpty()) {
                    throw new ParseException("Unrecognized maven.config entries: " + unrecongized);
                }
            }
        }
        catch (ParseException e) {
            System.err.println("Unable to parse maven.config: " + e.getMessage());
            cliManager.displayHelp(this.output);
            throw e;
        }
        try {
            args.addAll(0, Arrays.asList(cliRequest.getArgs()));
            cliRequest.setCommandLine(cliManager.parse(args.toArray(new String[args.size()])));
        }
        catch (ParseException e) {
            System.err.println("Unable to parse command line options: " + e.getMessage());
            cliManager.displayHelp(this.output);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            cliManager.displayHelp(ps);
            throw e;
        }
        if (cliRequest.getCommandLine().hasOption('h')) {
            cliManager.displayHelp(this.output);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            cliManager.displayHelp(ps);
            throw new ExitException(0);
        }
        if (cliRequest.getCommandLine().hasOption('v')) {
            System.out.println(AFCLIReportingUtils.showVersion());
            throw new ExitException(0);
        }
    }

    protected void logging(AFCliRequest cliRequest) {
        cliRequest.setDebug(cliRequest.getCommandLine().hasOption('X'));
        cliRequest.setQuiet(!cliRequest.isDebug() && cliRequest.getCommandLine().hasOption('q'));
        cliRequest.setShowErrors(cliRequest.isDebug() || cliRequest.getCommandLine().hasOption('e'));
        this.slf4jLoggerFactory = LoggerFactory.getILoggerFactory();
        Slf4jConfiguration slf4jConfiguration = Slf4jConfigurationFactory.getConfiguration((ILoggerFactory)this.slf4jLoggerFactory);
        if (cliRequest.isDebug()) {
            cliRequest.getRequest().setLoggingLevel(0);
            slf4jConfiguration.setRootLoggerLevel(Slf4jConfiguration.Level.DEBUG);
        } else if (cliRequest.isQuiet()) {
            cliRequest.getRequest().setLoggingLevel(3);
            slf4jConfiguration.setRootLoggerLevel(Slf4jConfiguration.Level.ERROR);
        }
        if (cliRequest.getCommandLine().hasOption("l")) {
            File logFile = new File(cliRequest.getCommandLine().getOptionValue("l").trim());
            logFile = AFMavenCli.resolveFile(logFile, cliRequest.getWorkingDirectory());
            try {
                PrintStream ps = new PrintStream(new FileOutputStream(logFile));
                System.setOut(ps);
                System.setErr(ps);
            }
            catch (FileNotFoundException e) {
                logger.error(e.getMessage());
            }
        }
        slf4jConfiguration.activate();
        this.plexusLoggerManager = new Slf4jLoggerManager();
        this.slf4jLogger = this.slf4jLoggerFactory.getLogger(this.getClass().getName());
    }

    protected void version(AFCliRequest cliRequest) {
        if (cliRequest.isDebug() || cliRequest.getCommandLine().hasOption('V')) {
            System.out.println(AFCLIReportingUtils.showVersion());
        }
    }

    protected void commands(AFCliRequest cliRequest) {
        if (cliRequest.isShowErrors()) {
            this.slf4jLogger.info("Error stacktraces are turned on.");
        }
        if ("warn".equals(cliRequest.getRequest().getGlobalChecksumPolicy())) {
            this.slf4jLogger.info("Disabling strict checksum verification on all artifact downloads.");
        } else if ("fail".equals(cliRequest.getRequest().getGlobalChecksumPolicy())) {
            this.slf4jLogger.info("Enabling strict checksum verification on all artifact downloads.");
        }
    }

    protected void properties(AFCliRequest cliRequest) {
        AFMavenCli.populateProperties(cliRequest.getCommandLine(), cliRequest.getSystemProperties(), cliRequest.getUserProperties());
    }

    protected PlexusContainer container(AFCliRequest cliRequest, ClassWorld classWorld) throws Exception {
        ClassRealm coreRealm;
        if (cliRequest.getClassWorld() == null) {
            cliRequest.setClassWorld(classWorld);
        }
        if ((coreRealm = cliRequest.getClassWorld().getClassRealm("plexus.core")) == null) {
            coreRealm = (ClassRealm)cliRequest.getClassWorld().getRealms().iterator().next();
        }
        List<File> extClassPath = this.parseExtClasspath(cliRequest);
        CoreExtensionEntry coreEntry = CoreExtensionEntry.discoverFrom((ClassRealm)coreRealm);
        List<CoreExtensionEntry> extensions = this.loadCoreExtensions(cliRequest, coreRealm, coreEntry.getExportedArtifacts());
        ClassRealm containerRealm = this.setupContainerRealm(cliRequest.getClassWorld(), coreRealm, extClassPath, extensions);
        ContainerConfiguration cc = new DefaultContainerConfiguration().setClassWorld(cliRequest.getClassWorld()).setRealm(containerRealm).setClassPathScanning("index").setAutoWiring(true).setName("maven");
        HashSet exportedArtifacts = new HashSet(coreEntry.getExportedArtifacts());
        HashSet exportedPackages = new HashSet(coreEntry.getExportedPackages());
        for (CoreExtensionEntry extension : extensions) {
            exportedArtifacts.addAll(extension.getExportedArtifacts());
            exportedPackages.addAll(extension.getExportedPackages());
        }
        final CoreExports exports = new CoreExports(containerRealm, exportedArtifacts, exportedPackages);
        DefaultPlexusContainer container = new DefaultPlexusContainer(cc, new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(ILoggerFactory.class).toInstance((Object)AFMavenCli.this.slf4jLoggerFactory);
                this.bind(CoreExports.class).toInstance((Object)exports);
            }
        }});
        container.addComponent(cliRequest.getMap(), HashMap.class, "kieMap");
        container.setLookupRealm(null);
        container.setLoggerManager(this.plexusLoggerManager);
        for (CoreExtensionEntry extension : extensions) {
            container.discoverComponents(extension.getClassRealm());
        }
        this.customizeContainer((PlexusContainer)container);
        container.getLoggerManager().setThresholds(cliRequest.getRequest().getLoggingLevel());
        Thread.currentThread().setContextClassLoader((ClassLoader)container.getContainerRealm());
        this.eventSpyDispatcher = (EventSpyDispatcher)container.lookup(EventSpyDispatcher.class);
        DefaultEventSpyContext eventSpyContext = new DefaultEventSpyContext();
        Map data = eventSpyContext.getData();
        data.put("plexus", container);
        data.put("workingDirectory", cliRequest.getWorkingDirectory());
        data.put("systemProperties", cliRequest.getSystemProperties());
        data.put("userProperties", cliRequest.getUserProperties());
        data.put("versionProperties", AFCLIReportingUtils.getBuildProperties());
        this.eventSpyDispatcher.init((EventSpy.Context)eventSpyContext);
        this.slf4jLogger = this.slf4jLoggerFactory.getLogger(this.getClass().getName());
        this.maven = (Maven)container.lookup(Maven.class);
        this.executionRequestPopulator = (MavenExecutionRequestPopulator)container.lookup(MavenExecutionRequestPopulator.class);
        this.modelProcessor = this.createModelProcessor((PlexusContainer)container);
        this.configurationProcessors = container.lookupMap(AFConfigurationProcessor.class);
        this.toolchainsBuilder = (ToolchainsBuilder)container.lookup(ToolchainsBuilder.class);
        this.dispatcher = (DefaultSecDispatcher)container.lookup(SecDispatcher.class, "maven");
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<CoreExtensionEntry> loadCoreExtensions(AFCliRequest cliRequest, ClassRealm containerRealm, Set<String> providedArtifacts) {
        List list;
        if (cliRequest.getMultiModuleProjectDirectory() == null) {
            return Collections.emptyList();
        }
        Path extensionsFile = Paths.get(cliRequest.getMultiModuleProjectDirectory().toString(), EXTENSIONS_FILENAME);
        if (!Files.isRegularFile(extensionsFile, new LinkOption[0])) {
            return Collections.emptyList();
        }
        List<CoreExtension> extensions = this.readCoreExtensionsDescriptor(extensionsFile);
        if (extensions.isEmpty()) {
            return Collections.emptyList();
        }
        ContainerConfiguration cc = new DefaultContainerConfiguration().setClassWorld(cliRequest.getClassWorld()).setRealm(containerRealm).setClassPathScanning("index").setAutoWiring(true).setName("maven");
        DefaultPlexusContainer container = new DefaultPlexusContainer(cc, new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(ILoggerFactory.class).toInstance((Object)AFMavenCli.this.slf4jLoggerFactory);
            }
        }});
        try {
            container.setLookupRealm(null);
            container.setLoggerManager(this.plexusLoggerManager);
            container.getLoggerManager().setThresholds(cliRequest.getRequest().getLoggingLevel());
            Thread.currentThread().setContextClassLoader((ClassLoader)container.getContainerRealm());
            this.executionRequestPopulator = (MavenExecutionRequestPopulator)container.lookup(MavenExecutionRequestPopulator.class);
            this.configurationProcessors = container.lookupMap(AFConfigurationProcessor.class);
            this.configure(cliRequest);
            MavenExecutionRequest request = DefaultMavenExecutionRequest.copy((MavenExecutionRequest)cliRequest.getRequest());
            request = this.populateRequest(cliRequest, request);
            request = this.executionRequestPopulator.populateDefaults(request);
            BootstrapCoreExtensionManager resolver = (BootstrapCoreExtensionManager)container.lookup(BootstrapCoreExtensionManager.class);
            list = resolver.loadCoreExtensions(request, providedArtifacts, extensions);
            this.executionRequestPopulator = null;
        }
        catch (Throwable throwable) {
            try {
                this.executionRequestPopulator = null;
                container.dispose();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                this.slf4jLogger.warn("Failed to read extensions descriptor " + extensionsFile + ": " + e.getMessage());
                return Collections.emptyList();
            }
        }
        container.dispose();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<CoreExtension> readCoreExtensionsDescriptor(Path extensionsFile) throws IOException, XmlPullParserException {
        List list;
        CoreExtensionsXpp3Reader parser = new CoreExtensionsXpp3Reader();
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new ByteArrayInputStream(Files.readAllBytes(extensionsFile)));
            list = parser.read((InputStream)is).getExtensions();
        }
        catch (Throwable throwable) {
            IOUtil.close(is);
            throw throwable;
        }
        IOUtil.close((InputStream)is);
        return list;
    }

    protected ClassRealm setupContainerRealm(ClassWorld classWorld, ClassRealm coreRealm, List<File> extClassPath, List<CoreExtensionEntry> extensions) throws Exception {
        if (!extClassPath.isEmpty() || !extensions.isEmpty()) {
            ClassRealm extRealm = classWorld.newRealm("maven.ext", null);
            extRealm.setParentRealm(coreRealm);
            this.slf4jLogger.debug("Populating class realm " + extRealm.getId());
            for (File file : extClassPath) {
                this.slf4jLogger.debug("  Included " + file);
                extRealm.addURL(file.toURI().toURL());
            }
            for (CoreExtensionEntry entry : AFMavenCli.reverse(extensions)) {
                Set exportedPackages = entry.getExportedPackages();
                ClassRealm realm = entry.getClassRealm();
                for (String exportedPackage : exportedPackages) {
                    extRealm.importFrom((ClassLoader)realm, exportedPackage);
                }
                if (!exportedPackages.isEmpty()) continue;
                extRealm.importFrom((ClassLoader)realm, realm.getId());
            }
            return extRealm;
        }
        return coreRealm;
    }

    protected List<File> parseExtClasspath(AFCliRequest cliRequest) {
        String extClassPath = cliRequest.getUserProperties().getProperty(EXT_CLASS_PATH);
        if (extClassPath == null) {
            extClassPath = cliRequest.getSystemProperties().getProperty(EXT_CLASS_PATH);
        }
        ArrayList<File> jars = new ArrayList<File>();
        if (StringUtils.isNotEmpty((String)extClassPath)) {
            for (String jar : StringUtils.split((String)extClassPath, (String)File.pathSeparator)) {
                File file = AFMavenCli.resolveFile(new File(jar), cliRequest.getWorkingDirectory());
                this.slf4jLogger.debug("  Included " + file);
                jars.add(file);
            }
        }
        return jars;
    }

    protected void repository(AFCliRequest cliRequest) throws Exception {
        if (cliRequest.getCommandLine().hasOption("llr") || Boolean.getBoolean("maven.legacyLocalRepo")) {
            cliRequest.getRequest().setUseLegacyLocalRepository(true);
        }
    }

    protected int execute(AFCliRequest cliRequest) throws MavenExecutionRequestPopulationException {
        MavenExecutionRequest request = this.executionRequestPopulator.populateDefaults(cliRequest.getRequest());
        this.eventSpyDispatcher.onEvent((Object)request);
        MavenExecutionResult result = this.maven.execute(request);
        this.eventSpyDispatcher.onEvent((Object)result);
        this.eventSpyDispatcher.close();
        if (result.hasExceptions()) {
            DefaultExceptionHandler handler = new DefaultExceptionHandler();
            LinkedHashMap<String, String> references = new LinkedHashMap<String, String>();
            MavenProject project = null;
            for (Throwable throwable : result.getExceptions()) {
                ExceptionSummary summary = handler.handleException(throwable);
                this.logSummary(summary, references, "", cliRequest.isShowErrors());
                if (project != null || !(throwable instanceof LifecycleExecutionException)) continue;
                project = ((LifecycleExecutionException)throwable).getProject();
            }
            this.slf4jLogger.error("");
            if (!cliRequest.isShowErrors()) {
                this.slf4jLogger.error("To see the full stack trace of the errors, re-run Maven with the -e switch.");
            }
            if (!this.slf4jLogger.isDebugEnabled()) {
                this.slf4jLogger.error("Re-run Maven using the -X switch to enable full debug logging.");
            }
            if (!references.isEmpty()) {
                this.slf4jLogger.error("");
                this.slf4jLogger.error("For more information about the errors and possible solutions, please read the following articles:");
                for (Map.Entry entry : references.entrySet()) {
                    this.slf4jLogger.error((String)entry.getValue() + " " + (String)entry.getKey());
                }
            }
            if (project != null && !project.equals(result.getTopologicallySortedProjects().get(0))) {
                this.slf4jLogger.error("");
                this.slf4jLogger.error("After correcting the problems, you can resume the build with the command");
                this.slf4jLogger.error("  mvn <goals> -rf :" + project.getArtifactId());
            }
            if ("FAIL_NEVER".equals(cliRequest.getRequest().getReactorFailureBehavior())) {
                this.slf4jLogger.info("Build failures were ignored.");
                return 0;
            }
            return 1;
        }
        return 0;
    }

    protected void logSummary(ExceptionSummary summary, Map<String, String> references, String indent, boolean showErrors) {
        String referenceKey = "";
        if (StringUtils.isNotEmpty((String)summary.getReference()) && (referenceKey = references.get(summary.getReference())) == null) {
            referenceKey = "[Help " + (references.size() + 1) + "]";
            references.put(summary.getReference(), referenceKey);
        }
        String msg = summary.getMessage();
        if (StringUtils.isNotEmpty((String)referenceKey)) {
            msg = msg.indexOf(10) < 0 ? msg + " -> " + referenceKey : msg + "\n-> " + referenceKey;
        }
        String[] lines = msg.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < lines.length; ++i) {
            String line = indent + lines[i].trim();
            if (i == lines.length - 1 && (showErrors || summary.getException() instanceof InternalErrorException)) {
                this.slf4jLogger.error(line, summary.getException());
                continue;
            }
            this.slf4jLogger.error(line);
        }
        indent = indent + "  ";
        for (ExceptionSummary child : summary.getChildren()) {
            this.logSummary(child, references, indent, showErrors);
        }
    }

    protected void configure(AFCliRequest cliRequest) throws Exception {
        cliRequest.getRequest().setEventSpyDispatcher(this.eventSpyDispatcher);
        int userSuppliedConfigurationProcessorCount = this.configurationProcessors.size() - 1;
        if (userSuppliedConfigurationProcessorCount == 0) {
            this.configurationProcessors.get("settings").process(cliRequest);
        } else if (userSuppliedConfigurationProcessorCount == 1) {
            for (Map.Entry<String, AFConfigurationProcessor> entry : this.configurationProcessors.entrySet()) {
                String hint = entry.getKey();
                if (hint.equals("settings")) continue;
                AFConfigurationProcessor configurationProcessor = entry.getValue();
                configurationProcessor.process(cliRequest);
            }
        } else if (userSuppliedConfigurationProcessorCount > 1) {
            StringBuffer sb = new StringBuffer(String.format("%nThere can only be one user supplied ConfigurationProcessor, there are %s:%n%n", userSuppliedConfigurationProcessorCount));
            for (Map.Entry<String, AFConfigurationProcessor> entry : this.configurationProcessors.entrySet()) {
                String hint = entry.getKey();
                if (hint.equals("settings")) continue;
                AFConfigurationProcessor configurationProcessor = entry.getValue();
                sb.append(String.format("%s%n", configurationProcessor.getClass().getName()));
            }
            sb.append(String.format("%nn", new Object[0]));
            throw new Exception(sb.toString());
        }
    }

    protected void toolchains(AFCliRequest cliRequest) throws Exception {
        Path globalToolchainsFile;
        Path userToolchainsFile;
        if (cliRequest.getCommandLine().hasOption('t')) {
            userToolchainsFile = Paths.get(cliRequest.getCommandLine().getOptionValue('t'), new String[0]);
            if (!Files.isRegularFile(userToolchainsFile = AFMavenCli.resolvePath(userToolchainsFile, cliRequest.getWorkingDirectory()), new LinkOption[0])) {
                throw new FileNotFoundException("The specified user toolchains file does not exist: " + userToolchainsFile);
            }
        } else {
            userToolchainsFile = Paths.get(userMavenConfigurationHome.toString(), "toolchains.xml");
        }
        if (cliRequest.getCommandLine().hasOption("gt")) {
            globalToolchainsFile = Paths.get(cliRequest.getCommandLine().getOptionValue("gt"), new String[0]);
            if (!Files.isRegularFile(globalToolchainsFile = AFMavenCli.resolvePath(globalToolchainsFile, cliRequest.getWorkingDirectory()), new LinkOption[0])) {
                throw new FileNotFoundException("The specified global toolchains file does not exist: " + globalToolchainsFile);
            }
        } else {
            globalToolchainsFile = Paths.get(userMavenConfigurationHome.toString(), "toolchains.xml");
        }
        cliRequest.getRequest().setGlobalToolchainsFile(globalToolchainsFile.toFile());
        cliRequest.getRequest().setUserToolchainsFile(userToolchainsFile.toFile());
        DefaultToolchainsBuildingRequest toolchainsRequest = new DefaultToolchainsBuildingRequest();
        if (Files.isRegularFile(globalToolchainsFile, new LinkOption[0])) {
            toolchainsRequest.setGlobalToolchainsSource((Source)new FileSource(globalToolchainsFile.toFile()));
        }
        if (Files.isRegularFile(userToolchainsFile, new LinkOption[0])) {
            toolchainsRequest.setUserToolchainsSource((Source)new FileSource(userToolchainsFile.toFile()));
        }
        this.eventSpyDispatcher.onEvent((Object)toolchainsRequest);
        this.slf4jLogger.debug("Reading global toolchains from " + this.getLocation(toolchainsRequest.getGlobalToolchainsSource(), globalToolchainsFile));
        this.slf4jLogger.debug("Reading user toolchains from " + this.getLocation(toolchainsRequest.getUserToolchainsSource(), userToolchainsFile));
        ToolchainsBuildingResult toolchainsResult = this.toolchainsBuilder.build((ToolchainsBuildingRequest)toolchainsRequest);
        this.eventSpyDispatcher.onEvent((Object)toolchainsRequest);
        this.executionRequestPopulator.populateFromToolchains(cliRequest.getRequest(), toolchainsResult.getEffectiveToolchains());
        if (!toolchainsResult.getProblems().isEmpty() && this.slf4jLogger.isWarnEnabled()) {
            this.slf4jLogger.warn("");
            this.slf4jLogger.warn("Some problems were encountered while building the effective toolchains");
            for (Problem problem : toolchainsResult.getProblems()) {
                this.slf4jLogger.warn(problem.getMessage() + " @ " + problem.getLocation());
            }
            this.slf4jLogger.warn("");
        }
    }

    protected Object getLocation(Source source, Path defaultLocation) {
        if (source != null) {
            return source.getLocation();
        }
        return defaultLocation.toString();
    }

    protected MavenExecutionRequest populateRequest(AFCliRequest cliRequest) {
        return this.populateRequest(cliRequest, cliRequest.getRequest());
    }

    protected MavenExecutionRequest populateRequest(AFCliRequest cliRequest, MavenExecutionRequest request) {
        String threadConfiguration;
        File pom;
        String[] profileOptionValues;
        String[] deprecatedOptions;
        CommandLine commandLine = cliRequest.getCommandLine();
        String workingDirectory = cliRequest.getWorkingDirectory();
        boolean quiet = cliRequest.isQuiet();
        boolean showErrors = cliRequest.isShowErrors();
        for (String deprecatedOption : deprecatedOptions = new String[]{"up", "npu", "cpu", "npr"}) {
            if (!commandLine.hasOption(deprecatedOption)) continue;
            this.slf4jLogger.warn("Command line option -" + deprecatedOption + " is deprecated and will be removed in future Maven versions.");
        }
        if (commandLine.hasOption('B')) {
            request.setInteractiveMode(false);
        }
        boolean noSnapshotUpdates = false;
        if (commandLine.hasOption("nsu")) {
            noSnapshotUpdates = true;
        }
        List goals = commandLine.getArgList();
        boolean recursive = true;
        String reactorFailureBehaviour = "FAIL_FAST";
        if (commandLine.hasOption('N')) {
            recursive = false;
        }
        if (commandLine.hasOption("ff")) {
            reactorFailureBehaviour = "FAIL_FAST";
        } else if (commandLine.hasOption("fae")) {
            reactorFailureBehaviour = "FAIL_AT_END";
        } else if (commandLine.hasOption("fn")) {
            reactorFailureBehaviour = "FAIL_NEVER";
        }
        if (commandLine.hasOption('o')) {
            request.setOffline(true);
        }
        boolean updateSnapshots = false;
        if (commandLine.hasOption('U')) {
            updateSnapshots = true;
        }
        String globalChecksumPolicy = null;
        if (commandLine.hasOption('C')) {
            globalChecksumPolicy = "fail";
        } else if (commandLine.hasOption('c')) {
            globalChecksumPolicy = "warn";
        }
        File baseDirectory = new File(workingDirectory, "").getAbsoluteFile();
        ArrayList<String> activeProfiles = new ArrayList<String>();
        ArrayList<String> inactiveProfiles = new ArrayList<String>();
        if (commandLine.hasOption('P') && (profileOptionValues = commandLine.getOptionValues('P')) != null) {
            for (String profileOptionValue : profileOptionValues) {
                StringTokenizer profileTokens = new StringTokenizer(profileOptionValue, ",");
                while (profileTokens.hasMoreTokens()) {
                    String profileAction = profileTokens.nextToken().trim();
                    if (profileAction.startsWith("-") || profileAction.startsWith("!")) {
                        inactiveProfiles.add(profileAction.substring(1));
                        continue;
                    }
                    if (profileAction.startsWith("+")) {
                        activeProfiles.add(profileAction.substring(1));
                        continue;
                    }
                    activeProfiles.add(profileAction);
                }
            }
        }
        Object transferListener = quiet ? new QuietMavenTransferListener() : (request.isInteractiveMode() && !cliRequest.getCommandLine().hasOption("l") ? this.getConsoleTransferListener() : this.getBatchTransferListener());
        ExecutionEventLogger executionListener = new ExecutionEventLogger();
        if (this.eventSpyDispatcher != null) {
            executionListener = this.eventSpyDispatcher.chainListener((ExecutionListener)executionListener);
        }
        String alternatePomFile = null;
        if (commandLine.hasOption('f')) {
            alternatePomFile = commandLine.getOptionValue('f');
        }
        request.setBaseDirectory(baseDirectory).setGoals(goals).setSystemProperties(cliRequest.getSystemProperties()).setUserProperties(cliRequest.getUserProperties()).setReactorFailureBehavior(reactorFailureBehaviour).setRecursive(recursive).setShowErrors(showErrors).addActiveProfiles(activeProfiles).addInactiveProfiles(inactiveProfiles).setExecutionListener((ExecutionListener)executionListener).setTransferListener((TransferListener)transferListener).setUpdateSnapshots(updateSnapshots).setNoSnapshotUpdates(noSnapshotUpdates).setGlobalChecksumPolicy(globalChecksumPolicy).setMultiModuleProjectDirectory(new File(cliRequest.getMultiModuleProjectDirectory()));
        if (alternatePomFile != null) {
            File pom2 = AFMavenCli.resolveFile(new File(alternatePomFile.trim()), workingDirectory);
            if (pom2.isDirectory()) {
                pom2 = new File(pom2, "pom.xml");
            }
            request.setPom(pom2);
        } else if (this.modelProcessor != null && (pom = this.modelProcessor.locatePom(baseDirectory)).isFile()) {
            request.setPom(pom);
        }
        if (request.getPom() != null && request.getPom().getParentFile() != null) {
            request.setBaseDirectory(request.getPom().getParentFile());
        }
        if (commandLine.hasOption("rf")) {
            request.setResumeFrom(commandLine.getOptionValue("rf"));
        }
        if (commandLine.hasOption("pl")) {
            String[] projectOptionValues = commandLine.getOptionValues("pl");
            ArrayList<String> inclProjects = new ArrayList<String>();
            ArrayList<String> exclProjects = new ArrayList<String>();
            if (projectOptionValues != null) {
                for (String projectOptionValue : projectOptionValues) {
                    StringTokenizer projectTokens = new StringTokenizer(projectOptionValue, ",");
                    while (projectTokens.hasMoreTokens()) {
                        String projectAction = projectTokens.nextToken().trim();
                        if (projectAction.startsWith("-") || projectAction.startsWith("!")) {
                            exclProjects.add(projectAction.substring(1));
                            continue;
                        }
                        if (projectAction.startsWith("+")) {
                            inclProjects.add(projectAction.substring(1));
                            continue;
                        }
                        inclProjects.add(projectAction);
                    }
                }
            }
            request.setSelectedProjects(inclProjects);
            request.setExcludedProjects(exclProjects);
        }
        if (commandLine.hasOption("am") && !commandLine.hasOption("amd")) {
            request.setMakeBehavior("make-upstream");
        } else if (!commandLine.hasOption("am") && commandLine.hasOption("amd")) {
            request.setMakeBehavior("make-downstream");
        } else if (commandLine.hasOption("am") && commandLine.hasOption("amd")) {
            request.setMakeBehavior("make-both");
        }
        String localRepoProperty = request.getUserProperties().getProperty("maven.repo.local");
        if (localRepoProperty == null) {
            localRepoProperty = request.getSystemProperties().getProperty("maven.repo.local");
        }
        if (localRepoProperty != null) {
            request.setLocalRepositoryPath(localRepoProperty);
        }
        request.setCacheNotFound(true);
        request.setCacheTransferError(false);
        String string = threadConfiguration = commandLine.hasOption("T") ? commandLine.getOptionValue("T") : request.getSystemProperties().getProperty("maven.threads.experimental");
        if (threadConfiguration != null) {
            request.setBuilderId("multithreaded");
            if (threadConfiguration.contains("C")) {
                request.setDegreeOfConcurrency(this.calculateDegreeOfConcurrencyWithCoreMultiplier(threadConfiguration));
            } else {
                request.setDegreeOfConcurrency(Integer.valueOf(threadConfiguration).intValue());
            }
        }
        if (commandLine.hasOption("b")) {
            request.setBuilderId(commandLine.getOptionValue("b"));
        }
        return request;
    }

    protected int calculateDegreeOfConcurrencyWithCoreMultiplier(String threadConfiguration) {
        int procs = Runtime.getRuntime().availableProcessors();
        return (int)(Float.valueOf(threadConfiguration.replace("C", "")).floatValue() * (float)procs);
    }

    protected TransferListener getConsoleTransferListener() {
        return new ConsoleMavenTransferListener(this.output);
    }

    protected TransferListener getBatchTransferListener() {
        return new Slf4jMavenTransferListener();
    }

    protected void customizeContainer(PlexusContainer container) {
    }

    protected ModelProcessor createModelProcessor(PlexusContainer container) throws ComponentLookupException {
        return (ModelProcessor)container.lookup(ModelProcessor.class);
    }

    static class ExitException
    extends Exception {
        public int exitCode;

        public ExitException(int exitCode) {
            this.exitCode = exitCode;
        }
    }
}

