/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.impl;

import java.util.Optional;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.RebaseResult;
import org.kie.workbench.common.services.backend.compiler.internalNIO.decorators.InternalNIOJGITCompilerBeforeDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGitUtils {
    private static final Logger logger = LoggerFactory.getLogger(InternalNIOJGITCompilerBeforeDecorator.class);
    private static String REMOTE = "origin";
    private final String COMPILED_EXTENSION = ".class";
    private final String REMOTE_BRANCH = "master";

    public static Boolean applyBefore(Optional<Git> repo) {
        Boolean result = Boolean.FALSE;
        if (repo.isPresent()) {
            try {
                Git git = repo.get();
                PullCommand pc = git.pull().setRemote(REMOTE).setRebase(Boolean.TRUE.booleanValue());
                PullResult pullRes = pc.call();
                RebaseResult rr = pullRes.getRebaseResult();
                if (rr.getStatus().equals((Object)RebaseResult.Status.UP_TO_DATE) || rr.getStatus().equals((Object)RebaseResult.Status.FAST_FORWARD)) {
                    result = Boolean.TRUE;
                }
                if (rr.getStatus().equals((Object)RebaseResult.Status.UNCOMMITTED_CHANGES)) {
                    PullResult pr = git.pull().call();
                    result = pr.isSuccessful() ? Boolean.TRUE : Boolean.FALSE;
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
            return result;
        }
        return result;
    }
}

