/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.internalNIO.impl;

import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.kie.workbench.common.services.backend.compiler.external339.AFCliRequest;
import org.kie.workbench.common.services.backend.compiler.internalNIO.InternalNIOCompilationRequest;
import org.kie.workbench.common.services.backend.compiler.internalNIO.InternalNIOWorkspaceCompilationInfo;
import org.uberfire.java.nio.file.Path;

public class InternalNIODefaultCompilationRequest
implements InternalNIOCompilationRequest {
    private AFCliRequest req;
    private InternalNIOWorkspaceCompilationInfo info;
    private String requestUUID;
    private Map map;
    private String mavenRepo;

    public InternalNIODefaultCompilationRequest(String mavenRepo, InternalNIOWorkspaceCompilationInfo info, String[] args, Map<String, Object> map, Boolean logRequested) {
        this.mavenRepo = mavenRepo;
        this.info = info;
        this.requestUUID = UUID.randomUUID().toString();
        this.map = map;
        String[] internalArgs = this.getInternalArgs(args, logRequested);
        this.req = new AFCliRequest(this.info.getPrjPath().toAbsolutePath().toString(), internalArgs, this.map, this.requestUUID, logRequested);
    }

    private String[] getInternalArgs(String[] args, Boolean logRequested) {
        String[] internalArgs;
        StringBuilder sbCompilationID = new StringBuilder().append("-Dcompilation.ID=").append(this.requestUUID);
        if (logRequested.booleanValue()) {
            StringBuilder sbLogID = new StringBuilder().append("-l ").append("log").append(".").append(this.requestUUID).append(".log");
            internalArgs = Arrays.copyOf(args, args.length + 2);
            internalArgs[args.length + 1] = sbLogID.toString();
        } else {
            internalArgs = Arrays.copyOf(args, args.length + 1);
        }
        internalArgs[args.length] = sbCompilationID.toString();
        return internalArgs;
    }

    public String getRequestUUID() {
        return this.requestUUID;
    }

    @Override
    public InternalNIOWorkspaceCompilationInfo getInfo() {
        return this.info;
    }

    public Optional<URI> getRepoURI() {
        return this.info.getRemoteRepo();
    }

    @Override
    public Optional<Path> getPomFile() {
        return this.info.getEnhancedMainPomFile();
    }

    public AFCliRequest getReq() {
        return this.req;
    }

    @Override
    public AFCliRequest getKieCliRequest() {
        return this.req;
    }

    @Override
    public String getMavenRepo() {
        return this.mavenRepo;
    }
}

