/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.internalNIO.impl;

import java.util.Collections;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.kie.workbench.common.services.backend.compiler.CompilationResponse;
import org.kie.workbench.common.services.backend.compiler.configuration.Compilers;
import org.kie.workbench.common.services.backend.compiler.configuration.FileSystemImpl;
import org.kie.workbench.common.services.backend.compiler.external339.AFMavenCli;
import org.kie.workbench.common.services.backend.compiler.impl.DefaultCompilationResponse;
import org.kie.workbench.common.services.backend.compiler.impl.ProcessedPoms;
import org.kie.workbench.common.services.backend.compiler.internalNIO.InternalNIOCompilationRequest;
import org.kie.workbench.common.services.backend.compiler.internalNIO.InternalNIOIncrementalCompilerEnabler;
import org.kie.workbench.common.services.backend.compiler.internalNIO.InternalNIOMavenCompiler;
import org.kie.workbench.common.services.backend.compiler.internalNIO.impl.InternalNIODefaultIncrementalCompilerEnabler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;

public class InternalNIODefaultMavenCompiler
implements InternalNIOMavenCompiler {
    private static final Logger logger = LoggerFactory.getLogger(InternalNIODefaultMavenCompiler.class);
    private AFMavenCli cli = new AFMavenCli(FileSystemImpl.INTERNAL_NIO_IMPL);
    private InternalNIOIncrementalCompilerEnabler enabler = new InternalNIODefaultIncrementalCompilerEnabler(Compilers.JAVAC);

    public static Boolean isValidMavenRepo(Path mavenRepo) {
        if (mavenRepo.getParent() == null) {
            return Boolean.FALSE;
        }
        return Files.exists((Path)mavenRepo, (LinkOption[])new LinkOption[0]) && Files.isDirectory((Path)mavenRepo, (LinkOption[])new LinkOption[0]) && Files.isWritable((Path)mavenRepo) && Files.isReadable((Path)mavenRepo);
    }

    @Override
    public CompilationResponse compileSync(InternalNIOCompilationRequest req) {
        ProcessedPoms processedPoms;
        if (logger.isDebugEnabled()) {
            logger.debug("KieCompilationRequest:{}", (Object)req);
        }
        if (!req.getInfo().getEnhancedMainPomFile().isPresent() && !(processedPoms = this.enabler.process(req)).getResult().booleanValue()) {
            return new DefaultCompilationResponse(Boolean.FALSE, "Processing poms failed", Collections.emptyList());
        }
        req.getKieCliRequest().getRequest().setLocalRepositoryPath(req.getMavenRepo());
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        ClassWorld kieClassWorld = new ClassWorld("plexus.core", this.getClass().getClassLoader());
        int exitCode = this.cli.doMain(req.getKieCliRequest(), kieClassWorld);
        Thread.currentThread().setContextClassLoader(original);
        if (exitCode == 0) {
            return new DefaultCompilationResponse(Boolean.TRUE);
        }
        return new DefaultCompilationResponse(Boolean.FALSE);
    }
}

