/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.nio.decorators;

import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.RebaseResult;
import org.kie.workbench.common.services.backend.compiler.CompilationResponse;
import org.kie.workbench.common.services.backend.compiler.impl.DefaultCompilationResponse;
import org.kie.workbench.common.services.backend.compiler.nio.NIOCompilationRequest;
import org.kie.workbench.common.services.backend.compiler.nio.NIOMavenCompiler;
import org.kie.workbench.common.services.backend.compiler.nio.decorators.NIOCompilerDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIOJGITCompilerBeforeDecorator
implements NIOCompilerDecorator {
    private static final Logger logger = LoggerFactory.getLogger(NIOJGITCompilerBeforeDecorator.class);
    private final String COMPILED_EXTENSION = ".class";
    private final String REMOTE = "origin";
    private final String REMOTE_BRANCH = "master";
    private NIOMavenCompiler compiler;

    public NIOJGITCompilerBeforeDecorator(NIOMavenCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public CompilationResponse compileSync(NIOCompilationRequest req) {
        if (this.applyBefore(req).booleanValue()) {
            CompilationResponse res = this.compiler.compileSync(req);
            return res;
        }
        return new DefaultCompilationResponse(Boolean.FALSE);
    }

    private Boolean applyBefore(NIOCompilationRequest req) {
        Boolean result = Boolean.FALSE;
        if (req.getInfo().getGitRepo().isPresent()) {
            try {
                Git git = req.getInfo().getGitRepo().get();
                PullCommand pc = git.pull().setRemote("origin").setRebase(Boolean.TRUE.booleanValue());
                PullResult pullRes = pc.call();
                RebaseResult rr = pullRes.getRebaseResult();
                if (rr.getStatus().equals((Object)RebaseResult.Status.UP_TO_DATE) || rr.getStatus().equals((Object)RebaseResult.Status.FAST_FORWARD)) {
                    result = Boolean.TRUE;
                }
                if (rr.getStatus().equals((Object)RebaseResult.Status.UNCOMMITTED_CHANGES)) {
                    PullResult pr = git.pull().call();
                    result = pr.isSuccessful() ? Boolean.TRUE : Boolean.FALSE;
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
            return result;
        }
        return result;
    }
}

