/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.nio.decorators;

import org.kie.workbench.common.services.backend.compiler.CompilationResponse;
import org.kie.workbench.common.services.backend.compiler.impl.DefaultCompilationResponse;
import org.kie.workbench.common.services.backend.compiler.impl.LogUtils;
import org.kie.workbench.common.services.backend.compiler.nio.NIOCompilationRequest;
import org.kie.workbench.common.services.backend.compiler.nio.NIOMavenCompiler;
import org.kie.workbench.common.services.backend.compiler.nio.decorators.NIOCompilerDecorator;
import org.kie.workbench.common.services.backend.compiler.nio.decorators.kie.NIOKieAfterDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIOOutputLogAfterDecorator
implements NIOCompilerDecorator {
    private static final Logger logger = LoggerFactory.getLogger(NIOKieAfterDecorator.class);
    private NIOMavenCompiler compiler;

    public NIOOutputLogAfterDecorator(NIOMavenCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public CompilationResponse compileSync(NIOCompilationRequest req) {
        CompilationResponse res = this.compiler.compileSync(req);
        if (res.isSuccessful().booleanValue()) {
            return this.getDefaultCompilationResponse(Boolean.TRUE, req);
        }
        return this.getDefaultCompilationResponse(Boolean.FALSE, req);
    }

    public DefaultCompilationResponse getDefaultCompilationResponse(Boolean result, NIOCompilationRequest req) {
        return new DefaultCompilationResponse(result, LogUtils.getOutput(req.getInfo().getPrjPath().toAbsolutePath().toString(), req.getKieCliRequest().getRequestUUID()));
    }
}

