/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.nio.impl;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.kie.workbench.common.services.backend.compiler.configuration.Compilers;
import org.kie.workbench.common.services.backend.compiler.configuration.ConfigurationContextProvider;
import org.kie.workbench.common.services.backend.compiler.impl.PomPlaceHolder;
import org.kie.workbench.common.services.backend.compiler.impl.ProcessedPoms;
import org.kie.workbench.common.services.backend.compiler.nio.NIOCompilationRequest;
import org.kie.workbench.common.services.backend.compiler.nio.NIOIncrementalCompilerEnabler;
import org.kie.workbench.common.services.backend.compiler.nio.impl.NIODefaultPomEditor;
import org.kie.workbench.common.services.backend.compiler.nio.impl.NIOMavenUtils;

public class NIODefaultIncrementalCompilerEnabler
implements NIOIncrementalCompilerEnabler {
    private final String POM_NAME = "pom.xml";
    private NIODefaultPomEditor editor;

    public NIODefaultIncrementalCompilerEnabler(Compilers compiler) {
        this.editor = new NIODefaultPomEditor(new HashSet<PomPlaceHolder>(), new ConfigurationContextProvider(), compiler);
    }

    @Override
    public ProcessedPoms process(NIOCompilationRequest req) {
        Path mainPom = Paths.get(req.getInfo().getPrjPath().toString(), "pom.xml");
        if (!Files.isReadable(mainPom)) {
            return new ProcessedPoms(Boolean.FALSE, Collections.emptyList());
        }
        PomPlaceHolder placeHolder = this.editor.readSingle(mainPom);
        Boolean isPresent = this.isPresent(placeHolder);
        if (placeHolder.isValid().booleanValue() && !isPresent.booleanValue()) {
            ArrayList<String> pomsList = new ArrayList<String>();
            NIOMavenUtils.searchPoms(Paths.get(req.getInfo().getPrjPath().toString(), new String[0]), pomsList);
            if (pomsList.size() > 0) {
                this.processFoundedPoms(pomsList, req);
            }
            return new ProcessedPoms(Boolean.TRUE, pomsList);
        }
        return new ProcessedPoms(Boolean.FALSE, Collections.emptyList());
    }

    private void processFoundedPoms(List<String> poms, NIOCompilationRequest request) {
        for (String pom : poms) {
            Path tmpPom = Paths.get(pom, new String[0]);
            PomPlaceHolder tmpPlaceHolder = this.editor.readSingle(tmpPom);
            if (this.isPresent(tmpPlaceHolder).booleanValue()) continue;
            this.editor.write(tmpPom, request);
        }
        Path mainPom = Paths.get(request.getInfo().getPrjPath().toAbsolutePath().toString(), "pom.xml");
        request.getInfo().lateAdditionEnhancedMainPomFile(mainPom);
    }

    private Boolean isPresent(PomPlaceHolder placeholder) {
        return this.editor.getHistory().contains(placeholder);
    }

    public Set<PomPlaceHolder> getHistory() {
        return Collections.unmodifiableSet(this.editor.getHistory());
    }
}

