/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.nio.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Set;
import org.apache.maven.model.Model;
import org.kie.workbench.common.services.backend.compiler.PluginPresents;
import org.kie.workbench.common.services.backend.compiler.configuration.Compilers;
import org.kie.workbench.common.services.backend.compiler.configuration.ConfigurationProvider;
import org.kie.workbench.common.services.backend.compiler.impl.DefaultPomEditor;
import org.kie.workbench.common.services.backend.compiler.impl.PomPlaceHolder;
import org.kie.workbench.common.services.backend.compiler.nio.NIOCompilationRequest;

public class NIODefaultPomEditor
extends DefaultPomEditor {
    public NIODefaultPomEditor(Set<PomPlaceHolder> history, ConfigurationProvider config, Compilers compiler) {
        super(history, config, compiler);
    }

    public PomPlaceHolder readSingle(Path pom) {
        PomPlaceHolder holder = new PomPlaceHolder();
        try {
            Model model = this.reader.read((InputStream)new ByteArrayInputStream(Files.readAllBytes(pom)));
            holder = new PomPlaceHolder(pom.toAbsolutePath().toString(), model.getArtifactId(), model.getGroupId(), model.getVersion(), model.getPackaging());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return holder;
    }

    public void write(Path pom, NIOCompilationRequest request) {
        try {
            Model model = this.reader.read((InputStream)new ByteArrayInputStream(Files.readAllBytes(pom)));
            if (model == null) {
                this.logger.error("Model null from pom file:", (Object)pom.toString());
                return;
            }
            PomPlaceHolder pomPH = new PomPlaceHolder(pom.toAbsolutePath().toString(), model.getArtifactId(), model.getGroupId(), model.getVersion(), model.getPackaging(), Files.readAllBytes(Paths.get(pom.toAbsolutePath().toString(), new String[0])));
            if (!this.history.contains(pomPH)) {
                PluginPresents plugs = this.updatePom(model);
                request.getInfo().lateAdditionKiePluginPresent(plugs.isKiePluginPresent());
                if (plugs.isKiePluginPresent().booleanValue()) {
                    String[] args = this.addCreateClasspathMavenArgs(request.getKieCliRequest().getArgs());
                    request.getKieCliRequest().setArgs(args);
                }
                if (plugs.pomOverwriteRequired().booleanValue()) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    this.writer.write((OutputStream)baos, model);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Pom changed:{}", (Object)new String(baos.toByteArray(), StandardCharsets.UTF_8));
                    }
                    if (pom.getParent() != null) {
                        Path tmp = Paths.get(pom.getParent().toAbsolutePath().toString(), "pom.xml");
                        Files.delete(tmp);
                        Files.write(tmp, baos.toByteArray(), StandardOpenOption.CREATE_NEW);
                    }
                }
                this.history.add(pomPH);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }
}

