/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.nio.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.workbench.common.services.backend.compiler.configuration.Decorator;
import org.kie.workbench.common.services.backend.compiler.nio.NIOMavenCompiler;
import org.kie.workbench.common.services.backend.compiler.nio.decorators.NIOJGITCompilerBeforeDecorator;
import org.kie.workbench.common.services.backend.compiler.nio.decorators.NIOOutputLogAfterDecorator;
import org.kie.workbench.common.services.backend.compiler.nio.impl.NIODefaultMavenCompiler;

public class NIOMavenCompilerFactory {
    private static Map<String, NIOMavenCompiler> compilers = new ConcurrentHashMap<String, NIOMavenCompiler>();

    private NIOMavenCompilerFactory() {
    }

    public static NIOMavenCompiler getCompiler(Decorator decorator) {
        NIOMavenCompiler compiler = compilers.get(decorator.name());
        if (compiler == null) {
            compiler = NIOMavenCompilerFactory.createAndAddNewCompiler(decorator);
        }
        return compiler;
    }

    private static NIOMavenCompiler createAndAddNewCompiler(Decorator decorator) {
        NIOMavenCompiler compiler;
        switch (decorator) {
            case NONE: {
                compiler = new NIODefaultMavenCompiler();
                break;
            }
            case JGIT_BEFORE: {
                compiler = new NIOJGITCompilerBeforeDecorator(new NIODefaultMavenCompiler());
                break;
            }
            case LOG_OUTPUT_AFTER: {
                compiler = new NIOOutputLogAfterDecorator(new NIODefaultMavenCompiler());
                break;
            }
            case JGIT_BEFORE_AND_LOG_AFTER: {
                compiler = new NIOJGITCompilerBeforeDecorator(new NIOOutputLogAfterDecorator(new NIODefaultMavenCompiler()));
                break;
            }
            default: {
                compiler = new NIODefaultMavenCompiler();
            }
        }
        compilers.put(decorator.name(), compiler);
        return compiler;
    }

    public static void deleteCompilers() {
        compilers = new ConcurrentHashMap<String, NIOMavenCompiler>();
    }

    public static void clearCompilers() {
        compilers.clear();
    }
}

