/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.nio.impl;

import java.net.URI;
import java.nio.file.Path;
import java.util.Optional;
import org.eclipse.jgit.api.Git;

public class NIOWorkspaceCompilationInfo {
    private Path prjPath;
    private Path enhancedMainPomFile;
    private URI remoteRepo;
    private Git gitRepo;
    private Boolean kiePluginPresent = Boolean.FALSE;

    public NIOWorkspaceCompilationInfo(Path prjPath, URI remoteRepo, Git gitRepo) {
        this.prjPath = prjPath;
        this.remoteRepo = remoteRepo;
        this.gitRepo = gitRepo;
    }

    public NIOWorkspaceCompilationInfo(Path prjPath) {
        this.prjPath = prjPath;
    }

    public Boolean lateAdditionEnhancedMainPomFile(Path enhancedPom) {
        if (this.enhancedMainPomFile == null && enhancedPom != null) {
            this.enhancedMainPomFile = enhancedPom;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean lateAdditionGitRepo(Git git) {
        if (this.gitRepo == null && git != null) {
            this.gitRepo = git;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean lateAdditionRemoteGitRepo(URI uri) {
        if (this.remoteRepo == null && uri != null) {
            this.remoteRepo = uri;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean lateAdditionKiePluginPresent(Boolean present) {
        if (this.kiePluginPresent == null && present != null) {
            this.kiePluginPresent = present;
            return Boolean.TRUE;
        }
        if (present != null) {
            this.kiePluginPresent = this.kiePluginPresent | present;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean isKiePluginPresent() {
        return this.kiePluginPresent;
    }

    public Optional<Git> getGitRepo() {
        if (this.gitRepo != null) {
            return Optional.of(this.gitRepo);
        }
        return Optional.empty();
    }

    public Path getPrjPath() {
        return this.prjPath;
    }

    public Optional<Path> getEnhancedMainPomFile() {
        if (this.enhancedMainPomFile != null) {
            return Optional.of(this.enhancedMainPomFile);
        }
        return Optional.empty();
    }

    public Optional<URI> getRemoteRepo() {
        if (this.remoteRepo != null) {
            return Optional.of(this.remoteRepo);
        }
        return Optional.empty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WorkspaceCompilationInfo{");
        sb.append("prjPath=").append(this.prjPath);
        sb.append(", enhancedMainPomFile=").append(this.enhancedMainPomFile);
        sb.append(", remoteRepo=").append(this.remoteRepo);
        sb.append('}');
        return sb.toString();
    }
}

