/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.nio.impl.kie;

import java.util.Collections;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.kie.workbench.common.services.backend.compiler.KieCompilationResponse;
import org.kie.workbench.common.services.backend.compiler.configuration.Compilers;
import org.kie.workbench.common.services.backend.compiler.configuration.FileSystemImpl;
import org.kie.workbench.common.services.backend.compiler.external339.AFMavenCli;
import org.kie.workbench.common.services.backend.compiler.impl.DefaultKieCompilationResponse;
import org.kie.workbench.common.services.backend.compiler.impl.ProcessedPoms;
import org.kie.workbench.common.services.backend.compiler.nio.NIOCompilationRequest;
import org.kie.workbench.common.services.backend.compiler.nio.NIOIncrementalCompilerEnabler;
import org.kie.workbench.common.services.backend.compiler.nio.NIOKieMavenCompiler;
import org.kie.workbench.common.services.backend.compiler.nio.impl.NIODefaultIncrementalCompilerEnabler;
import org.kie.workbench.common.services.backend.compiler.nio.impl.NIODefaultMavenCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIOKieDefaultMavenCompiler
implements NIOKieMavenCompiler {
    private static final Logger logger = LoggerFactory.getLogger(NIODefaultMavenCompiler.class);
    private AFMavenCli cli = new AFMavenCli(FileSystemImpl.NIO);
    private NIOIncrementalCompilerEnabler enabler = new NIODefaultIncrementalCompilerEnabler(Compilers.JAVAC);

    @Override
    public KieCompilationResponse compileSync(NIOCompilationRequest req) {
        ProcessedPoms processedPoms;
        if (logger.isDebugEnabled()) {
            logger.debug("KieCompilationRequest:{}", (Object)req);
        }
        if (!req.getInfo().getEnhancedMainPomFile().isPresent() && !(processedPoms = this.enabler.process(req)).getResult().booleanValue()) {
            return new DefaultKieCompilationResponse(Boolean.FALSE, "Processing poms failed", Collections.emptyList());
        }
        req.getKieCliRequest().getRequest().setLocalRepositoryPath(req.getMavenRepo());
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        ClassWorld kieClassWorld = new ClassWorld("plexus.core", this.getClass().getClassLoader());
        int exitCode = this.cli.doMain(req.getKieCliRequest(), kieClassWorld);
        Thread.currentThread().setContextClassLoader(original);
        if (exitCode == 0) {
            return new DefaultKieCompilationResponse(Boolean.TRUE);
        }
        return new DefaultKieCompilationResponse(Boolean.FALSE);
    }
}

