/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.compiler.nio.impl.kie;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.workbench.common.services.backend.compiler.configuration.KieDecorator;
import org.kie.workbench.common.services.backend.compiler.nio.NIOKieMavenCompiler;
import org.kie.workbench.common.services.backend.compiler.nio.decorators.kie.NIOKieAfterDecorator;
import org.kie.workbench.common.services.backend.compiler.nio.decorators.kie.NIOKieJGITCompilerBeforeDecorator;
import org.kie.workbench.common.services.backend.compiler.nio.decorators.kie.NIOKieOutputLogAfterDecorator;
import org.kie.workbench.common.services.backend.compiler.nio.impl.kie.NIOKieDefaultMavenCompiler;

public class NIOKieMavenCompilerFactory {
    private static Map<String, NIOKieMavenCompiler> compilers = new ConcurrentHashMap<String, NIOKieMavenCompiler>();

    private NIOKieMavenCompilerFactory() {
    }

    public static NIOKieMavenCompiler getCompiler(KieDecorator decorator) {
        NIOKieMavenCompiler compiler = compilers.get(decorator.name());
        if (compiler == null) {
            compiler = NIOKieMavenCompilerFactory.createAndAddNewCompiler(decorator);
        }
        return compiler;
    }

    private static NIOKieMavenCompiler createAndAddNewCompiler(KieDecorator decorator) {
        NIOKieMavenCompiler compiler;
        switch (decorator) {
            case NONE: {
                compiler = new NIOKieDefaultMavenCompiler();
                break;
            }
            case KIE_AFTER: {
                compiler = new NIOKieAfterDecorator(new NIOKieDefaultMavenCompiler());
                break;
            }
            case KIE_AND_LOG_AFTER: {
                compiler = new NIOKieAfterDecorator(new NIOKieOutputLogAfterDecorator(new NIOKieDefaultMavenCompiler()));
                break;
            }
            case JGIT_BEFORE: {
                compiler = new NIOKieJGITCompilerBeforeDecorator(new NIOKieDefaultMavenCompiler());
                break;
            }
            case LOG_OUTPUT_AFTER: {
                compiler = new NIOKieOutputLogAfterDecorator(new NIOKieDefaultMavenCompiler());
                break;
            }
            case JGIT_BEFORE_AND_LOG_AFTER: {
                compiler = new NIOKieJGITCompilerBeforeDecorator(new NIOKieOutputLogAfterDecorator(new NIOKieDefaultMavenCompiler()));
                break;
            }
            case JGIT_BEFORE_AND_KIE_AND_LOG_AFTER: {
                compiler = new NIOKieJGITCompilerBeforeDecorator(new NIOKieAfterDecorator(new NIOKieOutputLogAfterDecorator(new NIOKieDefaultMavenCompiler())));
                break;
            }
            default: {
                compiler = new NIOKieDefaultMavenCompiler();
            }
        }
        compilers.put(decorator.name(), compiler);
        return compiler;
    }

    public static void deleteCompilers() {
        compilers = new ConcurrentHashMap<String, NIOKieMavenCompiler>();
    }

    public static void clearCompilers() {
        compilers.clear();
    }
}

