/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.project;

import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.backend.server.ProjectResourcePathResolver;
import org.guvnor.common.services.project.backend.server.ResourceResolver;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.structure.backend.backcompat.BackwardCompatibleUtil;
import org.guvnor.structure.server.config.ConfigurationService;
import org.kie.workbench.common.services.shared.kmodule.KModuleService;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;

public class KieResourceResolver
extends ResourceResolver<KieProject> {
    private KModuleService kModuleService;

    public KieResourceResolver() {
    }

    @Inject
    public KieResourceResolver(@Named(value="ioStrategy") IOService ioService, POMService pomService, ConfigurationService configurationService, CommentedOptionFactory commentedOptionFactory, BackwardCompatibleUtil backward, KModuleService kModuleService, Instance<ProjectResourcePathResolver> resourcePathResolversInstance) {
        super(ioService, pomService, configurationService, commentedOptionFactory, backward, resourcePathResolversInstance);
        this.kModuleService = kModuleService;
    }

    public KieProject resolveProject(org.uberfire.backend.vfs.Path resource) {
        try {
            if (resource == null) {
                return null;
            }
            Path path = Paths.convert((org.uberfire.backend.vfs.Path)resource).normalize();
            if (Files.isRegularFile((Path)path, (LinkOption[])new LinkOption[0])) {
                path = path.getParent();
            }
            while (path.getNameCount() > 0 && !path.getFileName().toString().equals("src")) {
                if (this.hasPom(path) && this.hasKModule(path)) {
                    return this.makeProject(path);
                }
                path = path.getParent();
            }
            if (path.getNameCount() == 0) {
                return null;
            }
            if ((path = path.getParent()).getNameCount() == 0 || path == null) {
                return null;
            }
            if (!this.hasPom(path)) {
                return null;
            }
            if (!this.hasKModule(path)) {
                return null;
            }
            return this.makeProject(path);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    protected KieProject makeProject(Path nioProjectRootPath) {
        KieProject project = this.simpleProjectInstance(nioProjectRootPath);
        POM pom = (POM)this.pomService.load(project.getPomXMLPath());
        project.setPom(pom);
        this.addSecurityGroups((Project)project);
        return project;
    }

    public Package resolvePackage(org.uberfire.backend.vfs.Path resource) {
        try {
            if (resource == null) {
                return null;
            }
            KieProject project = this.resolveProject(resource);
            if (project == null) {
                return null;
            }
            if (this.isPom(resource) || this.kModuleService.isKModule(resource)) {
                return null;
            }
            return this.makePackage((Project)project, resource);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public KieProject simpleProjectInstance(Path nioProjectRootPath) {
        org.uberfire.backend.vfs.Path projectRootPath = Paths.convert((Path)nioProjectRootPath);
        return new KieProject(projectRootPath, Paths.convert((Path)nioProjectRootPath.resolve("pom.xml")), Paths.convert((Path)nioProjectRootPath.resolve("src/main/resources/META-INF/kmodule.xml")), Paths.convert((Path)nioProjectRootPath.resolve("project.imports")), Paths.convert((Path)nioProjectRootPath.resolve("project.repositories")), Paths.convert((Path)nioProjectRootPath.resolve("package-names-white-list")), projectRootPath.getFileName());
    }

    protected boolean hasKModule(Path path) {
        Path kmodulePath = path.resolve("src/main/resources/META-INF/kmodule.xml");
        return Files.exists((Path)kmodulePath, (LinkOption[])new LinkOption[0]);
    }
}

