/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.backend.server.helpers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.maven.project.ProjectBuildingException;
import org.appformer.maven.integration.embedder.MavenEmbedderException;
import org.appformer.maven.support.AFReleaseId;
import org.appformer.maven.support.PomModel;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.guvnor.m2repo.backend.server.GuvnorM2Repository;
import org.kie.api.builder.ReleaseId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PomModelResolver {
    private static final Logger log = LoggerFactory.getLogger(PomModelResolver.class);

    public static PomModel resolveFromJar(InputStream jarStream) {
        PomModel pomModel = null;
        try {
            String pomXML = GuvnorM2Repository.loadPomFromJar(jarStream);
            if (pomXML != null) {
                pomModel = PomModel.Parser.parse((String)"pom.xml", (InputStream)new ByteArrayInputStream(pomXML.getBytes()));
            }
        }
        catch (Exception e) {
            log.info("Failed to parse pom.xml for GAV information. Falling back to pom.properties.", (Throwable)e);
        }
        if (pomModel == null) {
            try {
                jarStream.reset();
                String pomProperties = GuvnorM2Repository.loadPomPropertiesFromJar(jarStream);
                if (pomProperties != null) {
                    ReleaseId releaseId = ReleaseIdImpl.fromPropertiesString((String)pomProperties);
                    pomModel = new PomModel.InternalModel();
                    ((PomModel.InternalModel)pomModel).setReleaseId((AFReleaseId)releaseId);
                }
            }
            catch (Exception e) {
                log.info("Failed to parse pom.properties for GAV information.");
            }
        }
        return pomModel;
    }

    public static PomModel resolveFromPom(InputStream pomStream) throws Exception {
        try {
            return PomModel.Parser.parse((String)"pom.xml", (InputStream)pomStream);
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                if (e.getCause() instanceof ProjectBuildingException) {
                    throw (ProjectBuildingException)e.getCause();
                }
                if (e.getCause() instanceof MavenEmbedderException) {
                    throw (MavenEmbedderException)e.getCause();
                }
            }
            log.info("Failed to process pom.xml for GAV information.", (Throwable)e);
            throw e;
        }
    }
}

