/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.backend.server.repositories;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.guvnor.m2repo.backend.server.repositories.ArtifactRepository;
import org.guvnor.m2repo.backend.server.repositories.Repository;

@ApplicationScoped
public class ArtifactRepositoryService {
    public static final String LOCAL_M2_REPO_NAME = "local-m2-repo";
    public static final String GLOBAL_M2_REPO_NAME = "global-m2-repo";
    public static final String WORKSPACE_M2_REPO_NAME = "workspace-m2-repo";
    public static final String DISTRIBUTION_MANAGEMENT_REPO_NAME = "distribution-management-repo";
    public static final String ORG_GUVNOR_M2REPO_DIR_PROPERTY = "org.guvnor.m2repo.dir";
    private List<ArtifactRepository> repositories;

    public ArtifactRepositoryService() {
    }

    @Inject
    public ArtifactRepositoryService(@Repository @Any Instance<ArtifactRepository> artifactRepositoryInstances) {
        this.repositories = new ArrayList<ArtifactRepository>();
        for (ArtifactRepository artifactRepository : artifactRepositoryInstances) {
            this.repositories.add(artifactRepository);
        }
    }

    public List<? extends ArtifactRepository> getRepositories() {
        return this.repositories.stream().filter(ArtifactRepository::isRepository).collect(Collectors.toList());
    }

    public List<? extends ArtifactRepository> getPomRepositories() {
        return this.repositories.stream().filter(ArtifactRepository::isPomRepository).collect(Collectors.toList());
    }
}

