/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.indexing;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.kie.workbench.common.services.refactoring.IndexElementsGenerator;
import org.kie.workbench.common.services.refactoring.Resource;
import org.kie.workbench.common.services.refactoring.ResourceReference;
import org.kie.workbench.common.services.refactoring.SharedPart;
import org.kie.workbench.common.services.refactoring.backend.server.impact.ResourceReferenceCollector;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.util.KObjectUtil;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.metadata.engine.Indexer;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KObjectKey;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

public abstract class AbstractFileIndexer
implements Indexer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractFileIndexer.class);
    @Inject
    @Named(value="ioStrategy")
    protected IOService ioService;
    @Inject
    protected KieProjectService projectService;

    protected abstract DefaultIndexBuilder fillIndexBuilder(Path var1) throws Exception;

    public KObject toKObject(Path path) {
        KObject index = null;
        try {
            DefaultIndexBuilder builder = this.fillIndexBuilder(path);
            Set<Object> indexElements = null;
            indexElements = builder != null ? builder.build() : Collections.emptySet();
            index = KObjectUtil.toKObject(path, "refactor-info", indexElements);
        }
        catch (Exception e) {
            logger.error("Unable to index '" + path.toUri().toString() + "'.", (Object)e.getMessage(), (Object)e);
        }
        return index;
    }

    protected DefaultIndexBuilder getIndexBuilder(Path path) {
        Project project = this.projectService.resolveProject(Paths.convert((Path)path));
        if (project == null) {
            logger.error("Unable to index " + path.toUri().toString() + ": project could not be resolved.");
            return null;
        }
        Package pkg = this.projectService.resolvePackage(Paths.convert((Path)path));
        if (pkg == null) {
            logger.error("Unable to index " + path.toUri().toString() + ": package could not be resolved.");
            return null;
        }
        return new DefaultIndexBuilder(Paths.convert((Path)path).getFileName(), project, pkg);
    }

    protected void addReferencedResourcesToIndexBuilder(DefaultIndexBuilder builder, ResourceReferenceCollector resRefCollector) {
        Collection<Resource> resources;
        Collection<SharedPart> sharedReferences;
        Collection<ResourceReference> referencedResources = resRefCollector.getResourceReferences();
        if (!referencedResources.isEmpty()) {
            for (ResourceReference resourceRef : referencedResources) {
                builder.addGenerator((IndexElementsGenerator)resourceRef);
            }
        }
        if (!(sharedReferences = resRefCollector.getSharedReferences()).isEmpty()) {
            for (SharedPart sharedRef : sharedReferences) {
                builder.addGenerator((IndexElementsGenerator)sharedRef);
            }
        }
        if (!(resources = resRefCollector.getResources()).isEmpty()) {
            for (Resource res : resources) {
                builder.addGenerator((IndexElementsGenerator)res);
            }
        }
    }

    public KObjectKey toKObjectKey(Path path) {
        return KObjectUtil.toKObjectKey(path, "refactor-info");
    }
}

