/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.xml.format;

import org.drools.workbench.jcr2vfsmigration.xml.ExportXmlUtils;
import org.drools.workbench.jcr2vfsmigration.xml.format.CategoriesXmlFormat;
import org.drools.workbench.jcr2vfsmigration.xml.format.XmlFormat;
import org.drools.workbench.jcr2vfsmigration.xml.model.Categories;
import org.drools.workbench.jcr2vfsmigration.xml.model.Category;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CategoryXmlFormat
implements XmlFormat<Category> {
    public static final String CATEGORY = "category";
    public static final String CATEGORY_NAME = "name";
    private CategoriesXmlFormat categoriesXmlFormat;

    @Override
    public void format(StringBuilder sb, Category category) {
        if (sb == null || category == null) {
            throw new IllegalArgumentException("No output or Category specified");
        }
        this.initialize();
        sb.append("<").append(CATEGORY).append(" ").append(CATEGORY_NAME).append("=\"").append(ExportXmlUtils.escapeXml(category.getName())).append("\"").append(">");
        if (category.getCategories() != null) {
            this.categoriesXmlFormat.format(sb, category.getCategories());
        }
        sb.append("</").append(CATEGORY).append(">");
        System.out.format("Category [%s] exported. %n", category.getName());
    }

    @Override
    public Category parse(Node categoryNode) {
        NodeList subCategories;
        if (categoryNode == null || !CATEGORY.equals(categoryNode.getNodeName())) {
            throw new IllegalArgumentException("No input category node specified for parsing");
        }
        this.initialize();
        String name = null;
        Categories categories = null;
        NamedNodeMap attrs = categoryNode.getAttributes();
        if (attrs != null) {
            name = ExportXmlUtils.unEscapeXml(attrs.getNamedItem(CATEGORY_NAME).getNodeValue());
        }
        if ((subCategories = categoryNode.getChildNodes()).getLength() > 1) {
            throw new RuntimeException("Only one Categories element is allowed inside a Category");
        }
        if (subCategories.getLength() == 1) {
            categories = this.categoriesXmlFormat.parse(subCategories.item(0));
        }
        return new Category(name, categories);
    }

    private void initialize() {
        if (this.categoriesXmlFormat == null) {
            this.categoriesXmlFormat = new CategoriesXmlFormat();
        }
    }
}

