/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.xml;

import java.io.StringReader;
import java.text.MessageFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.drools.workbench.jcr2vfsmigration.xml.ExportXmlUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class CDataTest {
    private String simpleText = "This is a simple text.";
    private String oneNestedText = "This is a simple text with one nested <![CDATA[ cdata-section 1 ]]>, but that's all.";
    private String multiNestedText = "This is a simple text with a first nested <![CDATA[ cdata-section 1 ]]>, and also a second nested <![CDATA[ cdata-section 2 ]]>, in successive order.";
    private String levelNestedText = "This is a simple text with nested <![CDATA[ cdata-section 1, and also a second level nested <![CDATA[ cdata-section 2 ]]> section ]]>, multilevel.";
    private String multiLevelCombinedNestedText = "This is a simple text with a first nested <![CDATA[ cdata-section 1, and also a second level nested <![CDATA[ cdata-section 2 ]]> section ]]>, and also a third nested <![CDATA[ cdata-section 3 ]]>, in successive order.";
    private String simpleTextExpected = "<![CDATA[This is a simple text.]]>";
    private String oneNestedTextExpected = "<![CDATA[This is a simple text with one nested <![CDATA[ cdata-section 1 ]]]]><![CDATA[>, but that's all.]]>";
    private String multiNestedTextExpected = "<![CDATA[This is a simple text with a first nested <![CDATA[ cdata-section 1 ]]]]><![CDATA[>, and also a second nested <![CDATA[ cdata-section 2 ]]]]><![CDATA[>, in successive order.]]>";
    private String levelNestedTextExpected = "<![CDATA[This is a simple text with nested <![CDATA[ cdata-section 1, and also a second level nested <![CDATA[ cdata-section 2 ]]]]><![CDATA[> section ]]]]><![CDATA[>, multilevel.]]>";
    private String multiLevelCombinedNestedTextExpected = "<![CDATA[This is a simple text with a first nested <![CDATA[ cdata-section 1, and also a second level nested <![CDATA[ cdata-section 2 ]]]]><![CDATA[> section ]]]]><![CDATA[>, and also a third nested <![CDATA[ cdata-section 3 ]]]]><![CDATA[>, in successive order.]]>";
    private String templateXml = "<cdataParent>{0}</cdataParent>";

    @Test
    public void testFormatCdataSection() {
        Assert.assertEquals((Object)this.simpleTextExpected, (Object)ExportXmlUtils.formatCdataSection((String)this.simpleText));
        Assert.assertEquals((Object)this.oneNestedTextExpected, (Object)ExportXmlUtils.formatCdataSection((String)this.oneNestedText));
        Assert.assertEquals((Object)this.multiNestedTextExpected, (Object)ExportXmlUtils.formatCdataSection((String)this.multiNestedText));
        Assert.assertEquals((Object)this.levelNestedTextExpected, (Object)ExportXmlUtils.formatCdataSection((String)this.levelNestedText));
        Assert.assertEquals((Object)this.multiLevelCombinedNestedTextExpected, (Object)ExportXmlUtils.formatCdataSection((String)this.multiLevelCombinedNestedText));
    }

    @Test
    public void testParseCdataSections() {
        this.testXmlString(this.getXml(this.templateXml, this.simpleTextExpected), this.simpleText);
        this.testXmlString(this.getXml(this.templateXml, this.oneNestedTextExpected), this.oneNestedText);
        this.testXmlString(this.getXml(this.templateXml, this.multiNestedTextExpected), this.multiNestedText);
        this.testXmlString(this.getXml(this.templateXml, this.levelNestedTextExpected), this.levelNestedText);
        this.testXmlString(this.getXml(this.templateXml, this.multiLevelCombinedNestedTextExpected), this.multiLevelCombinedNestedText);
    }

    private void testXmlString(String strXml, String expectedResult) {
        InputSource is = new InputSource(new StringReader(strXml));
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document xml = db.parse(is);
            Node parentNode = xml.getFirstChild();
            if (parentNode != null && "cdataParent".equals(parentNode.getNodeName())) {
                Assert.assertEquals((Object)expectedResult, (Object)ExportXmlUtils.parseCdataSection((Node)parentNode));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getXml(String pattern, String escapedContent) {
        return MessageFormat.format(pattern, escapedContent);
    }
}

