/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.xml.format;

import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.drools.workbench.jcr2vfsmigration.xml.ExportXmlUtils;
import org.drools.workbench.jcr2vfsmigration.xml.format.XmlFormat;
import org.drools.workbench.jcr2vfsmigration.xml.model.Module;
import org.drools.workbench.jcr2vfsmigration.xml.model.ModuleType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModuleXmlFormat
implements XmlFormat<Module> {
    private static final Logger logger = LoggerFactory.getLogger(ModuleXmlFormat.class);
    protected static final String MODULE = "module";
    protected static final String MODULE_UUID = "uuid";
    protected static final String MODULE_TYPE = "type";
    protected static final String MODULE_NAME = "name";
    protected static final String MODULE_LAST_CONTRIBUTOR = "lastContrib";
    protected static final String MODULE_CHECKIN_COMMENT = "comment";
    protected static final String MODULE_LAST_MODIFIED = "lastModif";
    protected static final String MODULE_NORM_PACKAGENAME = "normalizedPackageName";
    protected static final String MODULE_PACKAGEHEADER = "packageHeaderInfo";
    protected static final String MODULE_GLOBALS = "globals";
    protected static final String MODULE_CATRULES = "catRules";
    protected static final String MODULE_ASSET_FILE = "assetExportFileName";

    @Override
    public void format(StringBuilder sb, Module module) {
        if (sb == null || module == null) {
            throw new IllegalArgumentException("No output or Module specified");
        }
        sb.append("<").append(MODULE).append(">");
        sb.append("<").append(MODULE_UUID).append(">").append(module.getUuid()).append("</").append(MODULE_UUID).append(">");
        sb.append("<").append(MODULE_TYPE).append(">").append((Object)module.getType()).append("</").append(MODULE_TYPE).append(">");
        sb.append("<").append(MODULE_NAME).append(">").append(ExportXmlUtils.escapeXml(module.getName())).append("</").append(MODULE_NAME).append(">");
        String lastContributor = StringUtils.isNotBlank((CharSequence)module.getLastContributor()) ? module.getLastContributor() : "--";
        sb.append("<").append(MODULE_LAST_CONTRIBUTOR).append(">").append(lastContributor).append("</").append(MODULE_LAST_CONTRIBUTOR).append(">");
        sb.append(this.formatCheckinComment(module.getCheckinComment()));
        Date lastModified = module.getLastModified() != null ? module.getLastModified() : new Date();
        sb.append("<").append(MODULE_LAST_MODIFIED).append(">").append(lastModified.getTime()).append("</").append(MODULE_LAST_MODIFIED).append(">");
        sb.append("<").append(MODULE_NORM_PACKAGENAME).append(">").append(module.getNormalizedPackageName()).append("</").append(MODULE_NORM_PACKAGENAME).append(">");
        sb.append("<").append(MODULE_ASSET_FILE).append(">").append(module.getAssetExportFileName()).append("</").append(MODULE_ASSET_FILE).append(">");
        sb.append(this.formatPackageHeaderInfo(module.getPackageHeaderInfo()));
        sb.append(this.formatGlobals(module.getGlobalsString()));
        sb.append(this.formatCatRules(module));
        sb.append("</").append(MODULE).append(">");
    }

    @Override
    public Module parse(Node moduleNode) {
        if (moduleNode == null || !MODULE.equals(moduleNode.getNodeName())) {
            throw new IllegalArgumentException("No input module node specified for parsing");
        }
        String name = null;
        String lastContributor = null;
        String checkinComment = null;
        Date lastModified = null;
        String normalizedPackageName = null;
        String uuid = null;
        String packageHeaderInfo = null;
        String globals = null;
        ModuleType type = null;
        Map<String, String> catRules = null;
        String assetExportFileName = null;
        NodeList moduleProps = moduleNode.getChildNodes();
        for (int i = 0; i < moduleProps.getLength(); ++i) {
            Node propertyNode = moduleProps.item(i);
            String nodeContent = propertyNode.getTextContent();
            if (MODULE_NAME.equalsIgnoreCase(propertyNode.getNodeName())) {
                name = ExportXmlUtils.unEscapeXml(nodeContent);
                continue;
            }
            if (MODULE_LAST_CONTRIBUTOR.equalsIgnoreCase(propertyNode.getNodeName())) {
                lastContributor = nodeContent;
                continue;
            }
            if (MODULE_CHECKIN_COMMENT.equalsIgnoreCase(propertyNode.getNodeName())) {
                checkinComment = this.parseCheckinComment(propertyNode);
                continue;
            }
            if (MODULE_LAST_MODIFIED.equalsIgnoreCase(propertyNode.getNodeName())) {
                lastModified = new Date(Long.parseLong(nodeContent, 10));
                continue;
            }
            if (MODULE_NORM_PACKAGENAME.equalsIgnoreCase(propertyNode.getNodeName())) {
                normalizedPackageName = nodeContent;
                continue;
            }
            if (MODULE_UUID.equalsIgnoreCase(propertyNode.getNodeName())) {
                uuid = nodeContent;
                continue;
            }
            if (MODULE_TYPE.equalsIgnoreCase(propertyNode.getNodeName())) {
                type = ModuleType.getByName(nodeContent);
                continue;
            }
            if (MODULE_PACKAGEHEADER.equalsIgnoreCase(propertyNode.getNodeName())) {
                packageHeaderInfo = this.parsePackageHeaderInfo(propertyNode);
                continue;
            }
            if (MODULE_GLOBALS.equalsIgnoreCase(propertyNode.getNodeName())) {
                globals = this.parseGlobals(propertyNode);
                continue;
            }
            if (MODULE_CATRULES.equalsIgnoreCase(propertyNode.getNodeName())) {
                catRules = this.parseCatRules(propertyNode);
                continue;
            }
            if (!MODULE_ASSET_FILE.equalsIgnoreCase(propertyNode.getNodeName())) continue;
            assetExportFileName = nodeContent;
        }
        return new Module(type, uuid, name, lastContributor, checkinComment, lastModified, normalizedPackageName, packageHeaderInfo, globals, catRules, assetExportFileName);
    }

    private String formatCheckinComment(String checkinComment) {
        StringBuilder sbCheckinComment = new StringBuilder("<");
        sbCheckinComment.append(MODULE_CHECKIN_COMMENT).append(">");
        if (StringUtils.isNotBlank((CharSequence)checkinComment)) {
            sbCheckinComment.append(ExportXmlUtils.formatCdataSection(checkinComment));
        }
        sbCheckinComment.append("</").append(MODULE_CHECKIN_COMMENT).append(">");
        return sbCheckinComment.toString();
    }

    private String parseCheckinComment(Node checkinCommentNode) {
        if (!MODULE_CHECKIN_COMMENT.equalsIgnoreCase(checkinCommentNode.getNodeName())) {
            throw new IllegalArgumentException("Wrong xml format: comment");
        }
        return ExportXmlUtils.parseCdataSection(checkinCommentNode);
    }

    private String formatCatRules(Module module) {
        StringBuilder sbCatRules = new StringBuilder("<").append(MODULE_CATRULES).append(">");
        Map<String, String> mapCatRules = module.getCatRules();
        if (mapCatRules.size() > 0) {
            sbCatRules.append(ExportXmlUtils.formatMap(mapCatRules));
        }
        sbCatRules.append("</").append(MODULE_CATRULES).append(">");
        return sbCatRules.toString();
    }

    private Map<String, String> parseCatRules(Node catRulesNode) {
        NodeList catRulesNodeChildren = catRulesNode.getChildNodes();
        if (catRulesNodeChildren.getLength() > 1) {
            throw new IllegalArgumentException("Wrong xml format: catRules");
        }
        Map<String, String> catRules = ExportXmlUtils.parseMap(catRulesNodeChildren.item(0));
        return catRules;
    }

    private String formatPackageHeaderInfo(String packageHeaderInfo) {
        StringBuilder sbPackageHeader = new StringBuilder("<");
        sbPackageHeader.append(MODULE_PACKAGEHEADER).append(">");
        if (StringUtils.isNotBlank((CharSequence)packageHeaderInfo)) {
            sbPackageHeader.append(ExportXmlUtils.formatCdataSection(packageHeaderInfo));
        }
        sbPackageHeader.append("</").append(MODULE_PACKAGEHEADER).append(">");
        return sbPackageHeader.toString();
    }

    private String parsePackageHeaderInfo(Node headerInfoNode) {
        if (!MODULE_PACKAGEHEADER.equalsIgnoreCase(headerInfoNode.getNodeName())) {
            throw new IllegalArgumentException("Wrong xml format: packageHeaderInfo");
        }
        return ExportXmlUtils.parseCdataSection(headerInfoNode);
    }

    private String formatGlobals(String globals) {
        StringBuilder sbGlobals = new StringBuilder("<");
        sbGlobals.append(MODULE_GLOBALS).append(">");
        if (StringUtils.isNotBlank((CharSequence)globals)) {
            sbGlobals.append(ExportXmlUtils.formatCdataSection(globals));
        }
        sbGlobals.append("</").append(MODULE_GLOBALS).append(">");
        return sbGlobals.toString();
    }

    private String parseGlobals(Node globalsNode) {
        if (!MODULE_GLOBALS.equalsIgnoreCase(globalsNode.getNodeName())) {
            throw new IllegalArgumentException("Wrong xml format: globals");
        }
        return ExportXmlUtils.parseCdataSection(globalsNode);
    }
}

