/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.rest;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.services.rest.DefaultGuvnorApprover;
import org.kie.workbench.common.services.rest.ProjectResourceDispatcher;
import org.kie.workbench.common.services.shared.rest.AddRepositoryToGroupRequest;
import org.kie.workbench.common.services.shared.rest.CompileProjectRequest;
import org.kie.workbench.common.services.shared.rest.CreateGroupRequest;
import org.kie.workbench.common.services.shared.rest.CreateOrCloneRepositoryRequest;
import org.kie.workbench.common.services.shared.rest.CreateProjectRequest;
import org.kie.workbench.common.services.shared.rest.DeployProjectRequest;
import org.kie.workbench.common.services.shared.rest.InstallProjectRequest;
import org.kie.workbench.common.services.shared.rest.JobRequest;
import org.kie.workbench.common.services.shared.rest.JobResult;
import org.kie.workbench.common.services.shared.rest.RemoveRepositoryFromGroupRequest;
import org.kie.workbench.common.services.shared.rest.RemoveRepositoryRequest;
import org.kie.workbench.common.services.shared.rest.TestProjectRequest;

@ApplicationScoped
public class KieSessionAsyncJobRequestObserver {
    @Inject
    protected ProjectResourceDispatcher projectResourceDispatcher;
    @Inject
    protected DefaultGuvnorApprover defaultGuvnorApprover;
    @Inject
    private Event<JobResult> jobResultEvent;

    public void onCreateOrCloneRepositoryRequest(@Observes CreateOrCloneRepositoryRequest jobRequest) {
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        this.projectResourceDispatcher.createOrCloneRepository(jobRequest.getJodId(), jobRequest.getRepository());
    }

    public void onRemoveRepositoryRequest(@Observes RemoveRepositoryRequest jobRequest) {
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        this.projectResourceDispatcher.removeRepository(jobRequest.getJodId(), jobRequest.getRepositoryName());
    }

    public void onCreateProjectRequest(@Observes CreateProjectRequest jobRequest) {
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        this.projectResourceDispatcher.createProject(jobRequest.getJodId(), jobRequest.getRepositoryName(), jobRequest.getProjectName());
    }

    public void onCompileProjectRequest(@Observes CompileProjectRequest jobRequest) {
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        this.projectResourceDispatcher.compileProject(jobRequest.getJodId(), jobRequest.getRepositoryName(), jobRequest.getProjectName(), jobRequest.getBuildConfig());
    }

    public void onInstallProjectRequest(@Observes InstallProjectRequest jobRequest) {
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        this.projectResourceDispatcher.installProject(jobRequest.getJodId(), jobRequest.getRepositoryName(), jobRequest.getProjectName(), jobRequest.getBuildConfig());
    }

    public void onTestProjectRequest(@Observes TestProjectRequest jobRequest) {
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        this.projectResourceDispatcher.testProject(jobRequest.getJodId(), jobRequest.getRepositoryName(), jobRequest.getProjectName(), jobRequest.getBuildConfig());
    }

    public void onDeployProjectRequest(@Observes DeployProjectRequest jobRequest) {
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        this.projectResourceDispatcher.installProject(jobRequest.getJodId(), jobRequest.getRepositoryName(), jobRequest.getProjectName(), jobRequest.getBuildConfig());
    }

    public void onCreateGroupRequest(@Observes CreateGroupRequest jobRequest) {
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        this.projectResourceDispatcher.createGroup(jobRequest.getJodId(), jobRequest.getGroupName(), jobRequest.getOwnder(), jobRequest.getRepositories());
    }

    public void onAddRepositoryToGroupRequest(@Observes AddRepositoryToGroupRequest jobRequest) {
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        this.projectResourceDispatcher.addRepositoryToGroup(jobRequest.getJodId(), jobRequest.getGroupName(), jobRequest.getRepositoryName());
    }

    public void onAddRepositoryToGroupRequest(@Observes RemoveRepositoryFromGroupRequest jobRequest) {
        if (!this.approveRequest((JobRequest)jobRequest)) {
            return;
        }
        this.projectResourceDispatcher.removeRepositoryFromGroup(jobRequest.getJodId(), jobRequest.getGroupName(), jobRequest.getRepositoryName());
    }

    public boolean approveRequest(JobRequest jobRequest) {
        if (!this.defaultGuvnorApprover.requestApproval(jobRequest)) {
            JobResult result = new JobResult();
            result.setJodId(jobRequest.getJodId());
            result.setStatus(JobRequest.Status.DENIED);
            result.setResult("The request is denied.");
            this.jobResultEvent.fire((Object)result);
            return false;
        }
        return true;
    }
}

