/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.rest;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.screens.testscenario.model.Failure;
import org.drools.workbench.screens.testscenario.model.TestResultMessage;
import org.drools.workbench.screens.testscenario.service.ScenarioTestEditorService;
import org.guvnor.common.services.project.builder.model.BuildMessage;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.file.FileAlreadyExistsException;
import org.kie.commons.java.nio.file.Path;
import org.kie.workbench.common.services.shared.rest.BuildConfig;
import org.kie.workbench.common.services.shared.rest.JobRequest;
import org.kie.workbench.common.services.shared.rest.JobResult;
import org.kie.workbench.common.services.shared.rest.RepositoryRequest;
import org.uberfire.backend.group.Group;
import org.uberfire.backend.group.GroupService;
import org.uberfire.backend.group.impl.GroupImpl;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.repositories.RepositoryService;
import org.uberfire.backend.repositories.impl.git.GitRepository;
import org.uberfire.backend.server.util.Paths;

@ApplicationScoped
public class ProjectResourceDispatcher {
    @Inject
    RepositoryService repositoryService;
    @Inject
    protected ProjectService projectService;
    @Inject
    private Paths paths;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioSystemService;
    @Inject
    protected BuildService buildService;
    @Inject
    GroupService groupService;
    @Inject
    private Event<JobResult> jobResultEvent;
    @Inject
    protected ScenarioTestEditorService scenarioTestEditorService;

    public void createOrCloneRepository(String jobId, RepositoryRequest repository) {
        System.out.println("-----ProjectResourceDispatcher:createOrCloneRepository--- , repository name:" + repository.getName());
        JobResult result = new JobResult();
        result.setJodId(jobId);
        if (repository.getRequestType() == null || "".equals(repository.getRequestType()) || !"new".equals(repository.getRequestType()) && !"clone".equals(repository.getRequestType())) {
            result.setStatus(JobRequest.Status.BAD_REQUEST);
            result.setResult("Repository request type can only be new or clone.");
            this.jobResultEvent.fire((Object)result);
            return;
        }
        String scheme = "git";
        if ("new".equals(repository.getRequestType())) {
            if (repository.getName() == null || "".equals(repository.getName())) {
                result.setStatus(JobRequest.Status.BAD_REQUEST);
                result.setResult("Repository name must be provided");
                this.jobResultEvent.fire((Object)result);
                return;
            }
            HashMap<String, Object> env = new HashMap<String, Object>(3);
            if (repository.getUserName() != null && !"".equals(repository.getUserName())) {
                env.put("username", repository.getUserName());
            }
            if (repository.getPassword() != null && !"".equals(repository.getPassword())) {
                env.put("crypt:password", repository.getPassword());
            }
            env.put("init", true);
            Repository newlyCreatedRepo = this.repositoryService.createRepository("git", repository.getName(), env);
            if (newlyCreatedRepo != null) {
                result.setStatus(JobRequest.Status.SUCCESS);
                result.setResult("Alias: " + newlyCreatedRepo.getAlias() + ", Scheme: " + newlyCreatedRepo.getScheme() + ", Uri: " + newlyCreatedRepo.getUri());
            } else {
                result.setStatus(JobRequest.Status.FAIL);
            }
        } else if ("clone".equals(repository.getRequestType())) {
            if (repository.getName() == null || "".equals(repository.getName()) || repository.getGitURL() == null || "".equals(repository.getGitURL())) {
                result.setStatus(JobRequest.Status.BAD_REQUEST);
                result.setResult("Repository name and GitURL must be provided");
            }
            HashMap<String, String> env = new HashMap<String, String>(3);
            if (repository.getUserName() != null && !"".equals(repository.getUserName())) {
                env.put("username", repository.getUserName());
            }
            if (repository.getPassword() != null && !"".equals(repository.getPassword())) {
                env.put("crypt:password", repository.getPassword());
            }
            env.put("origin", repository.getGitURL());
            Repository newlyCreatedRepo = this.repositoryService.createRepository("git", repository.getName(), env);
            if (newlyCreatedRepo != null) {
                result.setStatus(JobRequest.Status.SUCCESS);
                result.setResult("Alias: " + newlyCreatedRepo.getAlias() + ", Scheme: " + newlyCreatedRepo.getScheme() + ", Uri: " + newlyCreatedRepo.getUri());
            } else {
                result.setStatus(JobRequest.Status.FAIL);
            }
        }
        this.jobResultEvent.fire((Object)result);
    }

    public void removeRepository(String jobId, String repositoryName) {
        System.out.println("-----removeRepository--- , repository name:" + repositoryName);
        JobResult result = new JobResult();
        result.setJodId(jobId);
        if (repositoryName == null || "".equals(repositoryName)) {
            result.setStatus(JobRequest.Status.BAD_REQUEST);
            result.setResult("Repository name must be provided");
        }
        this.repositoryService.removeRepository(repositoryName);
        result.setStatus(JobRequest.Status.SUCCESS);
        this.jobResultEvent.fire((Object)result);
    }

    public void createProject(String jobId, String repositoryName, String projectName) {
        System.out.println("-----ProjectResourceDispatcher:createProject--- , repositoryName:" + repositoryName + ", project name:" + projectName);
        JobResult result = new JobResult();
        result.setJodId(jobId);
        Path repositoryPath = this.getRepositoryRootPath(repositoryName);
        if (repositoryPath == null) {
            result.setStatus(JobRequest.Status.RESOURCE_NOT_EXIST);
            result.setResult("Repository [" + repositoryName + "] does not exist");
            this.jobResultEvent.fire((Object)result);
            return;
        }
        POM pom = new POM();
        pom.getGav().setArtifactId(projectName);
        pom.getGav().setGroupId(projectName);
        pom.getGav().setVersion("1.0");
        try {
            Project project = this.projectService.newProject(this.makeRepository(this.paths.convert(repositoryPath, false)), projectName, pom, "/");
        }
        catch (FileAlreadyExistsException e) {
            result.setStatus(JobRequest.Status.DUPLICATE_RESOURCE);
            result.setResult("Project [" + projectName + "] already exists");
            this.jobResultEvent.fire((Object)result);
            return;
        }
        result.setStatus(JobRequest.Status.SUCCESS);
        this.jobResultEvent.fire((Object)result);
    }

    private Repository makeRepository(final org.uberfire.backend.vfs.Path repositoryRoot) {
        return new GitRepository(){

            public org.uberfire.backend.vfs.Path getRoot() {
                return repositoryRoot;
            }
        };
    }

    public void compileProject(String jobId, String repositoryName, String projectName, BuildConfig mavenConfig) {
        System.out.println("-----ProjectResourceDispatcher:compileProject--- , repositoryName:" + repositoryName + ", project name:" + projectName);
        JobResult result = new JobResult();
        result.setJodId(jobId);
        Path repositoryPath = this.getRepositoryRootPath(repositoryName);
        if (repositoryPath == null) {
            result.setStatus(JobRequest.Status.RESOURCE_NOT_EXIST);
            result.setResult("Repository [" + repositoryName + "] does not exist");
            this.jobResultEvent.fire((Object)result);
        } else {
            Project project = this.projectService.resolveProject(this.paths.convert(repositoryPath.resolve(projectName), false));
            if (project == null) {
                result.setStatus(JobRequest.Status.RESOURCE_NOT_EXIST);
                result.setResult("Project [" + projectName + "] does not exist");
                this.jobResultEvent.fire((Object)result);
                return;
            }
            BuildResults buildResults = this.buildService.build(project);
            result.setDetailedResult(this.buildResultsToDetailedStringMessages(buildResults.getMessages()));
            result.setStatus(buildResults.getMessages().isEmpty() ? JobRequest.Status.SUCCESS : JobRequest.Status.FAIL);
            this.jobResultEvent.fire((Object)result);
        }
    }

    private List<String> buildResultsToDetailedStringMessages(List<BuildMessage> messages) {
        ArrayList<String> result = new ArrayList<String>();
        for (BuildMessage message : messages) {
            String detailedStringMessage = "level:" + message.getLevel() + ", path:" + message.getPath() + ", text:" + message.getText();
            result.add(detailedStringMessage);
        }
        return result;
    }

    public void installProject(String jobId, String repositoryName, String projectName, BuildConfig mavenConfig) {
        System.out.println("-----ProjectResourceDispatcher:installProject--- , repositoryName:" + repositoryName + ", project name:" + projectName);
        JobResult result = new JobResult();
        result.setJodId(jobId);
        Path repositoryPath = this.getRepositoryRootPath(repositoryName);
        if (repositoryPath == null) {
            result.setStatus(JobRequest.Status.RESOURCE_NOT_EXIST);
            result.setResult("Repository [" + repositoryName + "] does not exist");
            this.jobResultEvent.fire((Object)result);
            return;
        }
        Project project = this.projectService.resolveProject(this.paths.convert(repositoryPath.resolve(projectName), false));
        if (project == null) {
            result.setStatus(JobRequest.Status.RESOURCE_NOT_EXIST);
            result.setResult("Project [" + projectName + "] does not exist");
            this.jobResultEvent.fire((Object)result);
            return;
        }
        BuildResults buildResults = this.buildService.buildAndDeploy(project);
        result.setDetailedResult(buildResults == null ? null : this.deployResultToDetailedStringMessages(buildResults));
        result.setStatus(buildResults.getMessages().isEmpty() ? JobRequest.Status.SUCCESS : JobRequest.Status.FAIL);
        this.jobResultEvent.fire((Object)result);
    }

    private List<String> deployResultToDetailedStringMessages(BuildResults deployResult) {
        GAV gav = deployResult.getGAV();
        List<String> result = this.buildResultsToDetailedStringMessages(deployResult.getMessages());
        String detailedStringMessage = "artifactID:" + gav.getArtifactId() + ", groupId:" + gav.getGroupId() + ", version:" + gav.getVersion();
        result.add(detailedStringMessage);
        return result;
    }

    public void testProject(String jobId, String repositoryName, String projectName, BuildConfig config) {
        System.out.println("-----ProjectResourceDispatcher:testProject--- , repositoryName:" + repositoryName + ", project name:" + projectName);
        final JobResult result = new JobResult();
        result.setJodId(jobId);
        Path repositoryPath = this.getRepositoryRootPath(repositoryName);
        if (repositoryPath == null) {
            result.setStatus(JobRequest.Status.RESOURCE_NOT_EXIST);
            result.setResult("Repository [" + repositoryName + "] does not exist");
            this.jobResultEvent.fire((Object)result);
            return;
        }
        Project project = this.projectService.resolveProject(this.paths.convert(repositoryPath.resolve(projectName), false));
        if (project == null) {
            result.setStatus(JobRequest.Status.RESOURCE_NOT_EXIST);
            result.setResult("Project [" + projectName + "] does not exist");
            this.jobResultEvent.fire((Object)result);
            return;
        }
        this.scenarioTestEditorService.runAllScenarios(project.getPomXMLPath(), (Event)new Event<TestResultMessage>(){

            public void fire(TestResultMessage event) {
                result.setDetailedResult(ProjectResourceDispatcher.this.testResultMessageToDetailedStringMessages(event));
                result.setStatus(event.wasSuccessful() ? JobRequest.Status.SUCCESS : JobRequest.Status.FAIL);
                ProjectResourceDispatcher.this.jobResultEvent.fire((Object)result);
            }

            public Event<TestResultMessage> select(Annotation ... qualifiers) {
                return null;
            }

            public <U extends TestResultMessage> Event<U> select(Class<U> subtype, Annotation ... qualifiers) {
                return null;
            }

            public <U extends TestResultMessage> Event<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
                return null;
            }
        });
    }

    private List<String> testResultMessageToDetailedStringMessages(TestResultMessage message) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("wasSuccessuful: " + message.wasSuccessful());
        result.add("RunCoun: " + message.getRunCount());
        result.add("FailureCount: " + message.getFailureCount());
        for (Failure failure : message.getFailures()) {
            result.add("Failure: " + failure.getMessage());
        }
        return result;
    }

    public void deployProject(String jobId, String repositoryName, String projectName, BuildConfig config) {
        System.out.println("-----ProjectResourceDispatcher:deployProject--- , repositoryName:" + repositoryName + ", project name:" + projectName);
        JobResult result = new JobResult();
        result.setJodId(jobId);
        Path repositoryPath = this.getRepositoryRootPath(repositoryName);
        if (repositoryPath == null) {
            result.setStatus(JobRequest.Status.RESOURCE_NOT_EXIST);
            result.setResult("Repository [" + repositoryName + "] does not exist");
            this.jobResultEvent.fire((Object)result);
            return;
        }
        Project project = this.projectService.resolveProject(this.paths.convert(repositoryPath.resolve(projectName), false));
        if (project == null) {
            result.setStatus(JobRequest.Status.RESOURCE_NOT_EXIST);
            result.setResult("Project [" + projectName + "] does not exist");
            this.jobResultEvent.fire((Object)result);
            return;
        }
        BuildResults buildResults = this.buildService.buildAndDeploy(project);
        result.setDetailedResult(buildResults == null ? null : this.deployResultToDetailedStringMessages(buildResults));
        result.setStatus(buildResults.getMessages().isEmpty() ? JobRequest.Status.SUCCESS : JobRequest.Status.FAIL);
        this.jobResultEvent.fire((Object)result);
    }

    public void createGroup(String jobId, String groupName, String groupOwer, List<String> repositoryNameList) {
        System.out.println("-----ProjectResourceDispatcher:createGroup--- , Group name:" + groupName + ", Group owner:" + groupOwer);
        JobResult result = new JobResult();
        result.setJodId(jobId);
        if (groupName == null || groupOwer == null) {
            result.setStatus(JobRequest.Status.BAD_REQUEST);
            result.setResult("Group name and owner must be provided");
            this.jobResultEvent.fire((Object)result);
            return;
        }
        Group group = null;
        ArrayList<GitRepository> repositories = new ArrayList<GitRepository>();
        if (repositoryNameList != null && repositoryNameList.size() > 0) {
            for (String repoName : repositoryNameList) {
                GitRepository repo = new GitRepository(repoName);
                repositories.add(repo);
            }
            group = this.groupService.createGroup(groupName, groupOwer, repositories);
        } else {
            group = this.groupService.createGroup(groupName, groupOwer);
        }
        if (group != null) {
            result.setResult("Group " + group.getName() + " is created successfully.");
            result.setStatus(JobRequest.Status.SUCCESS);
        } else {
            result.setStatus(JobRequest.Status.FAIL);
        }
        this.jobResultEvent.fire((Object)result);
    }

    public void addRepositoryToGroup(String jobId, String groupName, String repositoryName) {
        System.out.println("-----ProjectResourceDispatcher:addRepositoryToGroup--- , Group name:" + groupName + ", repository name:" + repositoryName);
        JobResult result = new JobResult();
        result.setJodId(jobId);
        if (groupName == null || repositoryName == null) {
            result.setStatus(JobRequest.Status.BAD_REQUEST);
            result.setResult("Group name and repository name must be provided");
            this.jobResultEvent.fire((Object)result);
            return;
        }
        GroupImpl group = new GroupImpl(groupName, null);
        GitRepository repo = new GitRepository(repositoryName);
        try {
            this.groupService.addRepository((Group)group, (Repository)repo);
        }
        catch (IllegalArgumentException e) {
            result.setStatus(JobRequest.Status.BAD_REQUEST);
            result.setResult("Group " + group.getName() + " not found");
            this.jobResultEvent.fire((Object)result);
            return;
        }
        result.setStatus(JobRequest.Status.SUCCESS);
        this.jobResultEvent.fire((Object)result);
    }

    public void removeRepositoryFromGroup(String jobId, String groupName, String repositoryName) {
        System.out.println("-----ProjectResourceDispatcher:removeRepositoryFromGroup--- , Group name:" + groupName + ", repository name:" + repositoryName);
        JobResult result = new JobResult();
        result.setJodId(jobId);
        if (groupName == null || repositoryName == null) {
            result.setStatus(JobRequest.Status.BAD_REQUEST);
            result.setResult("Group name and repository name must be provided");
            this.jobResultEvent.fire((Object)result);
            return;
        }
        GroupImpl group = new GroupImpl(groupName, null);
        GitRepository repo = new GitRepository(repositoryName);
        try {
            this.groupService.removeRepository((Group)group, (Repository)repo);
        }
        catch (IllegalArgumentException e) {
            result.setStatus(JobRequest.Status.BAD_REQUEST);
            result.setResult("Group " + group.getName() + " not found");
            this.jobResultEvent.fire((Object)result);
            return;
        }
        result.setStatus(JobRequest.Status.SUCCESS);
        this.jobResultEvent.fire((Object)result);
    }

    public Path getRepositoryRootPath(String repositoryName) {
        Repository repo = this.repositoryService.getRepository(repositoryName);
        if (repo == null) {
            return null;
        }
        return this.paths.convert(repo.getRoot());
    }
}

