/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import org.drools.workbench.screens.scenariosimulation.backend.server.ScenarioSimulationServiceImpl;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.guvnor.common.services.backend.config.SafeSessionInfo;
import org.guvnor.common.services.backend.metadata.MetadataServerSideService;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.backend.service.KieServiceOverviewLoader;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.ext.editor.commons.backend.service.SaveAndRenameServiceImpl;
import org.uberfire.ext.editor.commons.backend.version.PathResolver;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;

@RunWith(value=MockitoJUnitRunner.class)
public class ScenarioSimulationServiceImplTest {
    @Mock
    private IOService ioService;
    @Mock
    private CommentedOptionFactory commentedOptionFactory;
    @Mock
    private SaveAndRenameServiceImpl<ScenarioSimulationModel, Metadata> saveAndRenameService;
    @Mock
    private PathResolver pathResolver;
    @Mock
    protected KieServiceOverviewLoader overviewLoader;
    @Mock
    protected MetadataServerSideService metadataService;
    @Mock
    private DeleteService deleteService;
    @Mock
    private RenameService renameService;
    @Mock
    private CopyService copyService;
    @InjectMocks
    private ScenarioSimulationServiceImpl service = new ScenarioSimulationServiceImpl((SessionInfo)Mockito.mock(SafeSessionInfo.class));
    private org.uberfire.backend.vfs.Path path = PathFactory.newPath((String)"contextpath", (String)"file:///contextpath");

    @Test
    public void init() throws Exception {
        this.service.init();
        ((SaveAndRenameServiceImpl)Mockito.verify(this.saveAndRenameService)).init((SupportsSaveAndRename)this.service);
    }

    @Test
    public void delete() throws Exception {
        this.service.delete(this.path, "Removing this");
        ((DeleteService)Mockito.verify((Object)this.deleteService)).delete(this.path, "Removing this");
    }

    @Test
    public void rename() throws Exception {
        this.service.rename(this.path, "newName.scesim", "comment");
        ((RenameService)Mockito.verify((Object)this.renameService)).rename(this.path, "newName.scesim", "comment");
    }

    @Test
    public void copy() throws Exception {
        this.service.copy(this.path, "newName.scesim", "comment");
        ((CopyService)Mockito.verify((Object)this.copyService)).copy(this.path, "newName.scesim", "comment");
    }

    @Test
    public void copyToDirectory() throws Exception {
        org.uberfire.backend.vfs.Path folder = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        this.service.copy(this.path, "newName.scesim", folder, "comment");
        ((CopyService)Mockito.verify((Object)this.copyService)).copy(this.path, "newName.scesim", folder, "comment");
    }

    @Test
    public void saveAndRename() throws Exception {
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        ScenarioSimulationModel model = new ScenarioSimulationModel();
        this.service.saveAndRename(this.path, "newName.scesim", metadata, model, "comment");
        ((SaveAndRenameServiceImpl)Mockito.verify(this.saveAndRenameService)).saveAndRename(this.path, "newName.scesim", (Object)metadata, (Object)model, "comment");
    }

    @Test
    public void save() throws Exception {
        org.uberfire.backend.vfs.Path returnPath = this.service.save(this.path, new ScenarioSimulationModel(), new Metadata(), "Commit comment");
        Assert.assertNotNull((Object)returnPath);
        ((IOService)Mockito.verify((Object)this.ioService)).write((Path)Matchers.any(Path.class), Matchers.anyString(), Matchers.anyMap(), new OpenOption[]{(OpenOption)Matchers.any(CommentedOption.class)});
    }

    @Test
    public void create() throws Exception {
        ((IOService)Mockito.doReturn((Object)false).when((Object)this.ioService)).exists((Path)Matchers.any());
        org.uberfire.backend.vfs.Path returnPath = this.service.create(this.path, "test.scesim", new ScenarioSimulationModel(), "Commit comment");
        Assert.assertNotNull((Object)returnPath);
        ((IOService)Mockito.verify((Object)this.ioService)).write((Path)Matchers.any(Path.class), Matchers.anyString(), new OpenOption[]{(OpenOption)Matchers.any(CommentedOption.class)});
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void createFileExists() throws Exception {
        ((IOService)Mockito.doReturn((Object)true).when((Object)this.ioService)).exists((Path)Matchers.any());
        this.service.create(this.path, "test.scesim", new ScenarioSimulationModel(), "Commit comment");
    }
}

