/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import java.util.HashSet;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.screens.scenariosimulation.backend.server.ScenarioSimulationXMLPersistence;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModelContent;
import org.drools.workbench.screens.scenariosimulation.service.ScenarioRunnerService;
import org.drools.workbench.screens.scenariosimulation.service.ScenarioSimulationService;
import org.drools.workbench.screens.scenariosimulation.type.ScenarioSimulationResourceTypeDefinition;
import org.guvnor.common.services.backend.config.SafeSessionInfo;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;
import org.kie.workbench.common.services.backend.service.KieService;
import org.kie.workbench.common.services.datamodel.backend.server.DataModelOracleUtilities;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.backend.service.SaveAndRenameServiceImpl;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@Service
@ApplicationScoped
public class ScenarioSimulationServiceImpl
extends KieService<ScenarioSimulationModelContent>
implements ScenarioSimulationService {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private CopyService copyService;
    @Inject
    private DeleteService deleteService;
    @Inject
    private RenameService renameService;
    @Inject
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    @Inject
    private ScenarioSimulationResourceTypeDefinition resourceTypeDefinition;
    @Inject
    private CommentedOptionFactory commentedOptionFactory;
    @Inject
    private SaveAndRenameServiceImpl<ScenarioSimulationModel, Metadata> saveAndRenameService;
    @Inject
    private DataModelService dataModelService;
    @Inject
    private ScenarioRunnerService scenarioRunnerService;
    @Inject
    private User user;
    private SafeSessionInfo safeSessionInfo;

    public ScenarioSimulationServiceImpl() {
    }

    @Inject
    public ScenarioSimulationServiceImpl(SessionInfo sessionInfo) {
        this.safeSessionInfo = new SafeSessionInfo(sessionInfo);
    }

    @PostConstruct
    public void init() {
        this.saveAndRenameService.init((SupportsSaveAndRename)this);
    }

    public void runScenario(org.uberfire.backend.vfs.Path path, ScenarioSimulationModel model) {
        this.scenarioRunnerService.runTest(this.user.getIdentifier(), path, model);
    }

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path context, String fileName, ScenarioSimulationModel content, String comment) {
        try {
            Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)context).resolve(fileName);
            org.uberfire.backend.vfs.Path newPath = Paths.convert((Path)nioPath);
            if (this.ioService.exists(nioPath)) {
                throw new FileAlreadyExistsException(nioPath.toString());
            }
            this.ioService.write(nioPath, ScenarioSimulationXMLPersistence.getInstance().marshal(content), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
            return newPath;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public ScenarioSimulationModel load(org.uberfire.backend.vfs.Path path) {
        try {
            String content = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
            return ScenarioSimulationXMLPersistence.getInstance().unmarshal(content);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    protected ScenarioSimulationModelContent constructContent(org.uberfire.backend.vfs.Path path, Overview overview) {
        PackageDataModelOracle oracle = this.dataModelService.getDataModel(path);
        PackageDataModelOracleBaselinePayload dataModel = new PackageDataModelOracleBaselinePayload();
        HashSet consumedFQCNs = new HashSet();
        consumedFQCNs.addAll(oracle.getPackageGlobals().values());
        consumedFQCNs.addAll(oracle.getModuleCollectionTypes().entrySet().stream().filter(entry -> (Boolean)entry.getValue()).map(entry -> (String)entry.getKey()).collect(Collectors.toSet()));
        DataModelOracleUtilities.populateDataModel((PackageDataModelOracle)oracle, (PackageDataModelOracleBaselinePayload)dataModel, consumedFQCNs);
        this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path, (SessionInfo)this.safeSessionInfo));
        return new ScenarioSimulationModelContent(this.load(path), overview, dataModel);
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, ScenarioSimulationModel content, Metadata metadata, String comment) {
        try {
            Metadata currentMetadata = this.metadataService.getMetadata(resource);
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)resource), ScenarioSimulationXMLPersistence.getInstance().marshal(content), this.metadataService.setUpAttributes(resource, metadata), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
            this.fireMetadataSocialEvents(resource, currentMetadata, metadata);
            return resource;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        try {
            this.deleteService.delete(path, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.renameService.rename(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.copyService.copy(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, org.uberfire.backend.vfs.Path targetDirectory, String comment) {
        try {
            return this.copyService.copy(path, newName, targetDirectory, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path saveAndRename(org.uberfire.backend.vfs.Path path, String newFileName, Metadata metadata, ScenarioSimulationModel content, String comment) {
        return this.saveAndRenameService.saveAndRename(path, newFileName, (Object)metadata, (Object)content, comment);
    }
}

