/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.runner;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.drools.workbench.screens.scenariosimulation.backend.server.expression.BaseExpressionEvaluator;
import org.drools.workbench.screens.scenariosimulation.backend.server.expression.ExpressionEvaluator;
import org.drools.workbench.screens.scenariosimulation.backend.server.model.Dispute;
import org.drools.workbench.screens.scenariosimulation.backend.server.model.Person;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.ScenarioException;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.ScenarioRunnerHelper;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioInput;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioOutput;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioResult;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValue;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ScenarioRunnerHelperTest {
    private static final String NAME = "NAME";
    private static final double AMOUNT = 10.0;
    private static final String TEST_DESCRIPTION = "Test description";
    private static final ClassLoader classLoader = ScenarioRunnerHelperTest.class.getClassLoader();
    private static final ExpressionEvaluator expressionEvaluator = new BaseExpressionEvaluator(classLoader);
    private Simulation simulation;
    private FactIdentifier personFactIdentifier;
    private ExpressionIdentifier firstNameGivenExpressionIdentifier;
    private FactMapping firstNameGivenFactMapping;
    private Scenario scenario1;
    private Scenario scenario2;
    private ExpressionIdentifier firstNameExpectedExpressionIdentifier;
    private FactMapping firstNameExpectedFactMapping;
    private FactIdentifier disputeFactIdentifier;
    private ExpressionIdentifier amountGivenExpressionIdentifier;
    private FactMapping amountNameGivenFactMapping;
    private ExpressionIdentifier amountExpectedExpressionIdentifier;
    private FactMapping amountNameExpectedFactMapping;
    private FactMappingValue amountNameExpectedFactMappingValue;
    @Mock
    private EachTestNotifier singleNotifier;

    @Before
    public void setup() {
        this.simulation = new Simulation();
        this.personFactIdentifier = FactIdentifier.create((String)"Fact 1", (String)Person.class.getCanonicalName());
        this.firstNameGivenExpressionIdentifier = ExpressionIdentifier.create((String)"First Name Given", (FactMappingType)FactMappingType.GIVEN);
        this.firstNameGivenFactMapping = this.simulation.getSimulationDescriptor().addFactMapping(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier);
        this.firstNameGivenFactMapping.addExpressionElement("firstName", String.class.getCanonicalName());
        this.disputeFactIdentifier = FactIdentifier.create((String)"Fact 2", (String)Dispute.class.getCanonicalName());
        this.amountGivenExpressionIdentifier = ExpressionIdentifier.create((String)"Amount Given", (FactMappingType)FactMappingType.GIVEN);
        this.amountNameGivenFactMapping = this.simulation.getSimulationDescriptor().addFactMapping(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier);
        this.amountNameGivenFactMapping.addExpressionElement("amount", Double.class.getCanonicalName());
        this.firstNameExpectedExpressionIdentifier = ExpressionIdentifier.create((String)"First Name Expected", (FactMappingType)FactMappingType.EXPECTED);
        this.firstNameExpectedFactMapping = this.simulation.getSimulationDescriptor().addFactMapping(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier);
        this.firstNameExpectedFactMapping.addExpressionElement("firstName", String.class.getCanonicalName());
        this.amountExpectedExpressionIdentifier = ExpressionIdentifier.create((String)"Amount Expected", (FactMappingType)FactMappingType.EXPECTED);
        this.amountNameExpectedFactMapping = this.simulation.getSimulationDescriptor().addFactMapping(this.disputeFactIdentifier, this.amountExpectedExpressionIdentifier);
        this.amountNameExpectedFactMapping.addExpressionElement("amount", Double.class.getCanonicalName());
        this.scenario1 = this.simulation.addScenario();
        this.scenario1.setDescription(TEST_DESCRIPTION);
        this.scenario1.addMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, (Object)NAME);
        this.scenario1.addMappingValue(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier, (Object)NAME);
        this.scenario2 = this.simulation.addScenario();
        this.scenario2.setDescription(TEST_DESCRIPTION);
        this.scenario2.addMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, (Object)NAME);
        this.scenario2.addMappingValue(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier, (Object)NAME);
        this.scenario2.addMappingValue(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier, (Object)10.0);
        this.amountNameExpectedFactMappingValue = this.scenario2.addMappingValue(this.disputeFactIdentifier, this.amountExpectedExpressionIdentifier, (Object)10.0);
    }

    @Test
    public void extractGivenValuesTest() {
        List scenario1Inputs = ScenarioRunnerHelper.extractGivenValues((SimulationDescriptor)this.simulation.getSimulationDescriptor(), (List)this.scenario1.getUnmodifiableFactMappingValues(), (ClassLoader)classLoader, (ExpressionEvaluator)expressionEvaluator);
        Assert.assertEquals((long)1L, (long)scenario1Inputs.size());
        List scenario2Inputs = ScenarioRunnerHelper.extractGivenValues((SimulationDescriptor)this.simulation.getSimulationDescriptor(), (List)this.scenario2.getUnmodifiableFactMappingValues(), (ClassLoader)classLoader, (ExpressionEvaluator)expressionEvaluator);
        Assert.assertEquals((long)2L, (long)scenario2Inputs.size());
    }

    @Test
    public void extractExpectedValuesTest() {
        List scenario1Outputs = ScenarioRunnerHelper.extractExpectedValues((List)this.scenario1.getUnmodifiableFactMappingValues());
        Assert.assertEquals((long)1L, (long)scenario1Outputs.size());
        List scenario2Outputs = ScenarioRunnerHelper.extractExpectedValues((List)this.scenario2.getUnmodifiableFactMappingValues());
        Assert.assertEquals((long)2L, (long)scenario2Outputs.size());
    }

    @Test
    public void verifyConditionsTest() {
        List scenario1Inputs = ScenarioRunnerHelper.extractGivenValues((SimulationDescriptor)this.simulation.getSimulationDescriptor(), (List)this.scenario1.getUnmodifiableFactMappingValues(), (ClassLoader)classLoader, (ExpressionEvaluator)expressionEvaluator);
        List scenario1Outputs = ScenarioRunnerHelper.extractExpectedValues((List)this.scenario1.getUnmodifiableFactMappingValues());
        List scenario1Results = ScenarioRunnerHelper.verifyConditions((SimulationDescriptor)this.simulation.getSimulationDescriptor(), (List)scenario1Inputs, (List)scenario1Outputs, (ExpressionEvaluator)expressionEvaluator);
        Assert.assertEquals((long)1L, (long)scenario1Results.size());
        List scenario2Inputs = ScenarioRunnerHelper.extractGivenValues((SimulationDescriptor)this.simulation.getSimulationDescriptor(), (List)this.scenario2.getUnmodifiableFactMappingValues(), (ClassLoader)classLoader, (ExpressionEvaluator)expressionEvaluator);
        List scenario2Outputs = ScenarioRunnerHelper.extractExpectedValues((List)this.scenario2.getUnmodifiableFactMappingValues());
        List scenario2Results = ScenarioRunnerHelper.verifyConditions((SimulationDescriptor)this.simulation.getSimulationDescriptor(), (List)scenario2Inputs, (List)scenario2Outputs, (ExpressionEvaluator)expressionEvaluator);
        Assert.assertEquals((long)2L, (long)scenario2Results.size());
    }

    @Test
    public void verifyConditionsFailTest() {
        List scenario1Inputs = ScenarioRunnerHelper.extractGivenValues((SimulationDescriptor)this.simulation.getSimulationDescriptor(), (List)this.scenario1.getUnmodifiableFactMappingValues(), (ClassLoader)classLoader, (ExpressionEvaluator)expressionEvaluator);
        List scenario1Outputs = ScenarioRunnerHelper.extractExpectedValues((List)this.scenario1.getUnmodifiableFactMappingValues());
        scenario1Outputs.add(new ScenarioOutput(FactIdentifier.create((String)"NOT_EXISTING", (String)String.class.getCanonicalName()), new ArrayList()));
        String expectedMessage = "Some expected conditions are not linked to any given facts: NOT_EXISTING";
        Assertions.assertThatThrownBy(() -> ScenarioRunnerHelper.verifyConditions((SimulationDescriptor)this.simulation.getSimulationDescriptor(), (List)scenario1Inputs, (List)scenario1Outputs, (ExpressionEvaluator)expressionEvaluator)).hasMessage(expectedMessage).isInstanceOf(ScenarioException.class);
    }

    @Test
    public void getScenarioResultsTest() {
        List scenario1Inputs = ScenarioRunnerHelper.extractGivenValues((SimulationDescriptor)this.simulation.getSimulationDescriptor(), (List)this.scenario1.getUnmodifiableFactMappingValues(), (ClassLoader)classLoader, (ExpressionEvaluator)expressionEvaluator);
        List scenario1Outputs = ScenarioRunnerHelper.extractExpectedValues((List)this.scenario1.getUnmodifiableFactMappingValues());
        Assert.assertTrue((scenario1Inputs.size() > 0 ? 1 : 0) != 0);
        ScenarioInput input1 = (ScenarioInput)scenario1Inputs.get(0);
        scenario1Outputs = scenario1Outputs.stream().filter(elem -> elem.getFactIdentifier().equals((Object)input1.getFactIdentifier())).collect(Collectors.toList());
        List scenario1Results = ScenarioRunnerHelper.getScenarioResults((SimulationDescriptor)this.simulation.getSimulationDescriptor(), scenario1Outputs, (ScenarioInput)input1, (ExpressionEvaluator)expressionEvaluator);
        Assert.assertEquals((long)1L, (long)scenario1Results.size());
        List scenario2Inputs = ScenarioRunnerHelper.extractGivenValues((SimulationDescriptor)this.simulation.getSimulationDescriptor(), (List)this.scenario2.getUnmodifiableFactMappingValues(), (ClassLoader)classLoader, (ExpressionEvaluator)expressionEvaluator);
        List scenario2Outputs = ScenarioRunnerHelper.extractExpectedValues((List)this.scenario2.getUnmodifiableFactMappingValues());
        Assert.assertTrue((scenario2Inputs.size() > 0 ? 1 : 0) != 0);
        ScenarioInput input2 = (ScenarioInput)scenario2Inputs.get(0);
        scenario2Outputs = scenario2Outputs.stream().filter(elem -> elem.getFactIdentifier().equals((Object)input2.getFactIdentifier())).collect(Collectors.toList());
        List scenario2Results = ScenarioRunnerHelper.getScenarioResults((SimulationDescriptor)this.simulation.getSimulationDescriptor(), scenario2Outputs, (ScenarioInput)input2, (ExpressionEvaluator)expressionEvaluator);
        Assert.assertEquals((long)1L, (long)scenario2Results.size());
    }

    @Test
    public void validateAssertionTest() {
        ArrayList<ScenarioResult> scenarioFailResult = new ArrayList<ScenarioResult>();
        scenarioFailResult.add(new ScenarioResult(this.disputeFactIdentifier, this.amountNameExpectedFactMappingValue, (Object)"SOMETHING_ELSE", Boolean.valueOf(false)));
        try {
            ScenarioRunnerHelper.validateAssertion(scenarioFailResult, (Scenario)this.scenario2, (EachTestNotifier)this.singleNotifier);
            Assert.fail();
        }
        catch (ScenarioException scenarioException) {
            // empty catch block
        }
        ((EachTestNotifier)Mockito.verify((Object)this.singleNotifier, (VerificationMode)Mockito.times((int)1))).addFailedAssumption((AssumptionViolatedException)Mockito.any());
        Mockito.reset((Object[])new EachTestNotifier[]{this.singleNotifier});
        ArrayList<ScenarioResult> scenarioSuccessResult = new ArrayList<ScenarioResult>();
        scenarioSuccessResult.add(new ScenarioResult(this.disputeFactIdentifier, this.amountNameExpectedFactMappingValue, this.amountNameExpectedFactMappingValue.getRawValue(), Boolean.valueOf(true)));
        ScenarioRunnerHelper.validateAssertion(scenarioSuccessResult, (Scenario)this.scenario2, (EachTestNotifier)this.singleNotifier);
        ((EachTestNotifier)Mockito.verify((Object)this.singleNotifier, (VerificationMode)Mockito.times((int)0))).addFailedAssumption((AssumptionViolatedException)Mockito.any());
    }

    @Test
    public void groupByFactIdentifierAndFilterTest() {
        Map scenario1Given = ScenarioRunnerHelper.groupByFactIdentifierAndFilter((List)this.scenario1.getUnmodifiableFactMappingValues(), (FactMappingType)FactMappingType.GIVEN);
        Map scenario1Expected = ScenarioRunnerHelper.groupByFactIdentifierAndFilter((List)this.scenario1.getUnmodifiableFactMappingValues(), (FactMappingType)FactMappingType.EXPECTED);
        Map scenario2Given = ScenarioRunnerHelper.groupByFactIdentifierAndFilter((List)this.scenario2.getUnmodifiableFactMappingValues(), (FactMappingType)FactMappingType.GIVEN);
        Map scenario2Expected = ScenarioRunnerHelper.groupByFactIdentifierAndFilter((List)this.scenario2.getUnmodifiableFactMappingValues(), (FactMappingType)FactMappingType.EXPECTED);
        Assert.assertEquals((long)1L, (long)scenario1Given.keySet().size());
        Assert.assertEquals((long)1L, (long)scenario1Expected.keySet().size());
        Assert.assertEquals((long)2L, (long)scenario2Given.keySet().size());
        Assert.assertEquals((long)2L, (long)scenario2Expected.keySet().size());
        Assert.assertEquals((long)1L, (long)((List)scenario1Given.get(this.personFactIdentifier)).size());
        Assert.assertEquals((long)1L, (long)((List)scenario1Expected.get(this.personFactIdentifier)).size());
        Assert.assertEquals((long)1L, (long)((List)scenario2Given.get(this.disputeFactIdentifier)).size());
        Assert.assertEquals((long)1L, (long)((List)scenario2Expected.get(this.disputeFactIdentifier)).size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void groupByFactIdentifierAndFilterFailTest() {
        ArrayList<FactMappingValue> fail = new ArrayList<FactMappingValue>();
        fail.add(new FactMappingValue());
        ScenarioRunnerHelper.groupByFactIdentifierAndFilter(fail, (FactMappingType)FactMappingType.GIVEN);
    }
}

