/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.workbench.screens.scenariosimulation.backend.server.model.Dispute;
import org.drools.workbench.screens.scenariosimulation.backend.server.model.NotEmptyConstructor;
import org.drools.workbench.screens.scenariosimulation.backend.server.model.Person;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.ScenarioException;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.ScenarioRunnerHelperTest;
import org.drools.workbench.screens.scenariosimulation.backend.server.util.ScenarioBeanUtil;
import org.junit.Assert;
import org.junit.Test;

public class ScenarioBeanUtilTest {
    private static String FIRST_NAME = "firstNameToSet";
    private static int AGE = 10;
    private static ClassLoader classLoader = ScenarioBeanUtilTest.class.getClassLoader();

    @Test
    public void fillBeanTest() {
        HashMap<List<String>, Object> paramsToSet = new HashMap<List<String>, Object>();
        paramsToSet.put(Arrays.asList("creator", "firstName"), FIRST_NAME);
        paramsToSet.put(Arrays.asList("creator", "age"), AGE);
        Object result = ScenarioBeanUtil.fillBean((String)Dispute.class.getCanonicalName(), paramsToSet, (ClassLoader)classLoader);
        Assert.assertTrue((boolean)(result instanceof Dispute));
        Dispute dispute = (Dispute)result;
        Assert.assertEquals((Object)dispute.getCreator().getFirstName(), (Object)FIRST_NAME);
        Assert.assertEquals((long)dispute.getCreator().getAge(), (long)AGE);
    }

    @Test(expected=ScenarioException.class)
    public void fillBeanLoadClassTest() {
        ScenarioBeanUtil.fillBean((String)"FakeCanonicalName", new HashMap(), (ClassLoader)classLoader);
    }

    @Test(expected=ScenarioException.class)
    public void fillBeanFailNotEmptyConstructorTest() {
        HashMap<List<String>, Object> paramsToSet = new HashMap<List<String>, Object>();
        paramsToSet.put(Arrays.asList("name"), null);
        ScenarioBeanUtil.fillBean((String)NotEmptyConstructor.class.getCanonicalName(), paramsToSet, (ClassLoader)classLoader);
    }

    @Test(expected=ScenarioException.class)
    public void fillBeanFailTest() {
        HashMap<List<String>, Object> paramsToSet = new HashMap<List<String>, Object>();
        paramsToSet.put(Arrays.asList("fakeField"), null);
        ScenarioBeanUtil.fillBean((String)Dispute.class.getCanonicalName(), paramsToSet, (ClassLoader)classLoader);
    }

    @Test(expected=ScenarioException.class)
    public void fillBeanFailNullClassTest() {
        HashMap<List<String>, Object> paramsToSet = new HashMap<List<String>, Object>();
        paramsToSet.put(Arrays.asList("fakeField"), null);
        ScenarioBeanUtil.fillBean(null, paramsToSet, (ClassLoader)classLoader);
    }

    @Test
    public void fillBeanSimpleObjectTest() {
        HashMap paramsToSet = new HashMap();
        paramsToSet.put(Collections.emptyList(), "Test");
        ScenarioBeanUtil.fillBean((String)String.class.getCanonicalName(), paramsToSet, (ClassLoader)classLoader);
    }

    @Test
    public void navigateToObjectTest() {
        Dispute dispute = new Dispute();
        Person creator = new Person();
        creator.setFirstName(FIRST_NAME);
        dispute.setCreator(creator);
        List<String> pathToProperty = Arrays.asList("creator", "firstName");
        Object targetObject = ScenarioBeanUtil.navigateToObject((Object)dispute, pathToProperty, (boolean)true);
        Assert.assertEquals((Object)targetObject, (Object)FIRST_NAME);
    }

    @Test
    public void navigateToObjectNoStepTest() {
        String message = "Invalid path to a property, no steps provided";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.navigateToObject((Object)new Dispute(), new ArrayList(), (boolean)true)).isInstanceOf(ScenarioException.class)).hasMessage(message);
    }

    @Test
    public void navigateToObjectFakeFieldTest() {
        Dispute dispute = new Dispute();
        List<String> pathToProperty = Arrays.asList("fakeField");
        String message = "Impossible to find field with name 'fakeField' in class " + Dispute.class.getCanonicalName();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.navigateToObject((Object)dispute, (List)pathToProperty, (boolean)true)).isInstanceOf(ScenarioException.class)).hasMessage(message);
    }

    @Test
    public void navigateToObjectNoStepCreationTest() {
        Dispute dispute = new Dispute();
        List<String> pathToProperty = Arrays.asList("creator", "firstName");
        String message = "Impossible to reach field firstName because a step is not instantiated";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ScenarioBeanUtil.navigateToObject((Object)dispute, (List)pathToProperty, (boolean)false)).isInstanceOf(ScenarioException.class)).hasMessage(message);
    }

    @Test
    public void convertValueTest() {
        Assert.assertEquals((Object)"Test", (Object)ScenarioBeanUtil.convertValue((String)String.class.getCanonicalName(), (Object)"Test", (ClassLoader)classLoader));
        Assert.assertEquals((Object)false, (Object)ScenarioBeanUtil.convertValue((String)Boolean.TYPE.getCanonicalName(), (Object)"false", (ClassLoader)classLoader));
        Assert.assertEquals((Object)true, (Object)ScenarioBeanUtil.convertValue((String)Boolean.class.getCanonicalName(), (Object)"true", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1, (Object)ScenarioBeanUtil.convertValue((String)Integer.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1, (Object)ScenarioBeanUtil.convertValue((String)Integer.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1L, (Object)ScenarioBeanUtil.convertValue((String)Long.TYPE.getCanonicalName(), (Object)"1", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1L, (Object)ScenarioBeanUtil.convertValue((String)Long.class.getCanonicalName(), (Object)"1", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.TYPE.getCanonicalName(), (Object)"1.0", (ClassLoader)classLoader));
        Assert.assertEquals((Object)1.0, (Object)ScenarioBeanUtil.convertValue((String)Double.class.getCanonicalName(), (Object)"1.0", (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.TYPE.getCanonicalName(), (Object)"1.0", (ClassLoader)classLoader));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), (Object)"1.0", (ClassLoader)classLoader));
        Assert.assertNull((Object)ScenarioBeanUtil.convertValue((String)Float.class.getCanonicalName(), null, (ClassLoader)classLoader));
    }

    @Test(expected=IllegalArgumentException.class)
    public void convertValueFailLoadClassTest() {
        ScenarioBeanUtil.convertValue((String)"my.NotExistingClass", (Object)"Test", (ClassLoader)classLoader);
    }

    @Test(expected=IllegalArgumentException.class)
    public void convertValueFailUnsupportedTest() {
        ScenarioBeanUtil.convertValue((String)ScenarioRunnerHelperTest.class.getCanonicalName(), (Object)"Test", (ClassLoader)classLoader);
    }

    @Test(expected=IllegalArgumentException.class)
    public void convertValueFailPrimitiveNullTest() {
        ScenarioBeanUtil.convertValue((String)"int", null, (ClassLoader)classLoader);
    }

    @Test(expected=IllegalArgumentException.class)
    public void convertValueFailNotStringOrTypeTest() {
        ScenarioBeanUtil.convertValue((String)ScenarioRunnerHelperTest.class.getCanonicalName(), (Object)1, (ClassLoader)classLoader);
    }
}

