/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionElement;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValue;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModelContent;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.kie.soup.commons.xstream.XStreamUtils;
import org.kie.soup.project.datamodel.imports.Import;

public class ScenarioSimulationXMLPersistence {
    private XStream xt = XStreamUtils.createTrustingXStream((HierarchicalStreamDriver)new DomDriver());
    private static final ScenarioSimulationXMLPersistence INSTANCE = new ScenarioSimulationXMLPersistence();

    private ScenarioSimulationXMLPersistence() {
        this.xt.autodetectAnnotations(true);
        this.xt.alias("ExpressionElement", ExpressionElement.class);
        this.xt.alias("ExpressionIdentifier", ExpressionIdentifier.class);
        this.xt.alias("FactIdentifier", FactIdentifier.class);
        this.xt.alias("FactMapping", FactMapping.class);
        this.xt.alias("FactMappingType", FactMappingType.class);
        this.xt.alias("FactMappingValue", FactMappingValue.class);
        this.xt.alias("Scenario", Scenario.class);
        this.xt.alias("ScenarioSimulationModel", ScenarioSimulationModel.class);
        this.xt.alias("ScenarioSimulationModelContent", ScenarioSimulationModelContent.class);
        this.xt.alias("Simulation", Simulation.class);
        this.xt.alias("SimulationDescriptor", SimulationDescriptor.class);
        this.xt.alias("Import", Import.class);
    }

    public static ScenarioSimulationXMLPersistence getInstance() {
        return INSTANCE;
    }

    public String marshal(ScenarioSimulationModel sc) {
        return this.xt.toXML((Object)sc);
    }

    public ScenarioSimulationModel unmarshal(String xml) {
        if (xml == null) {
            return new ScenarioSimulationModel();
        }
        if (xml.trim().equals("")) {
            return new ScenarioSimulationModel();
        }
        Object o = this.xt.fromXML(xml);
        return (ScenarioSimulationModel)o;
    }
}

